/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.rules.AbstractSecurityRule;
import io.micronaut.security.rules.SecuredAnnotationRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.utils.LoggingUtils;
import io.micronaut.web.router.RouteMatch;
import jakarta.inject.Singleton;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Singleton
public class IpPatternsRule
extends AbstractSecurityRule {
    public static final Integer ORDER = SecuredAnnotationRule.ORDER - 100;
    private static final Logger LOG = LoggerFactory.getLogger(IpPatternsRule.class);
    private final List<Pattern> patternList;

    public IpPatternsRule(RolesFinder rolesFinder, SecurityConfiguration securityConfiguration) {
        super(rolesFinder);
        this.patternList = securityConfiguration.getIpPatterns().stream().map(Pattern::compile).collect(Collectors.toList());
    }

    public int getOrder() {
        return ORDER;
    }

    @Override
    public Publisher<SecurityRuleResult> check(HttpRequest<?> request, @Nullable RouteMatch<?> routeMatch, @Nullable Authentication authentication) {
        if (this.patternList.isEmpty()) {
            LoggingUtils.debug(LOG, "No IP patterns provided. Skipping host address check.", new Object[0]);
            return Mono.just((Object)((Object)SecurityRuleResult.UNKNOWN));
        }
        try {
            InetSocketAddress socketAddress = request.getRemoteAddress();
            if (socketAddress == null) {
                LoggingUtils.debug(LOG, "Request remote address was not found. Continuing request processing.", new Object[0]);
                return Mono.just((Object)((Object)SecurityRuleResult.UNKNOWN));
            }
            if (socketAddress.getAddress() == null) {
                LoggingUtils.debug(LOG, "Could not resolve the InetAddress. Continuing request processing.", new Object[0]);
                return Mono.just((Object)((Object)SecurityRuleResult.UNKNOWN));
            }
            String hostAddress = socketAddress.getAddress().getHostAddress();
            if (this.patternList.stream().anyMatch(pattern -> pattern.pattern().equals("0.0.0.0") || pattern.matcher(hostAddress).matches())) {
                LoggingUtils.debug(LOG, "One or more of the IP patterns matched the host address [{}]. Continuing request processing.", hostAddress);
                return Mono.just((Object)((Object)SecurityRuleResult.UNKNOWN));
            }
            LoggingUtils.debug(LOG, "None of the IP patterns [{}] matched the host address [{}]. Rejecting the request.", this.patternList.stream().map(Pattern::pattern).collect(Collectors.toList()), hostAddress);
            return Mono.just((Object)((Object)SecurityRuleResult.REJECTED));
        }
        catch (IllegalArgumentException e) {
            LoggingUtils.debug(LOG, "IllegalArgumentException thrown while getting the request remote address. Continuing request processing.", new Object[0]);
            return Mono.just((Object)((Object)SecurityRuleResult.UNKNOWN));
        }
    }
}

