/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.filters;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.Ordered;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.management.endpoint.EndpointsFilter;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthorizationException;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.rules.SecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.web.router.RouteMatch;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requires(property="micronaut.security.filter.enabled", notEquals="false", defaultValue="true")
@Replaces(value=EndpointsFilter.class)
@Filter(value={"${micronaut.security.filter.pattern:/**}"})
public class SecurityFilter
implements HttpServerFilter {
    public static final String KEY = "io.micronaut.security.filters." + SecurityFilter.class.getSimpleName();
    public static final CharSequence AUTHENTICATION = HttpAttributes.PRINCIPAL.toString();
    public static final CharSequence REJECTION = "micronaut.security.REJECTION";
    public static final CharSequence TOKEN = "micronaut.TOKEN";
    private static final Logger LOG = LoggerFactory.getLogger(SecurityFilter.class);
    private static final Integer ORDER = ServerFilterPhase.SECURITY.order();
    protected final Collection<SecurityRule> securityRules;
    protected final Collection<AuthenticationFetcher> authenticationFetchers;
    protected final SecurityConfiguration securityConfiguration;

    public SecurityFilter(Collection<SecurityRule> securityRules, Collection<AuthenticationFetcher> authenticationFetchers, SecurityConfiguration securityConfiguration) {
        this.securityRules = securityRules;
        this.authenticationFetchers = authenticationFetchers;
        this.securityConfiguration = securityConfiguration;
    }

    public int getOrder() {
        return ORDER;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        request.getAttributes().put((CharSequence)KEY, (Object)true);
        RouteMatch routeMatch = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, RouteMatch.class).orElse(null);
        return Flux.fromIterable(this.authenticationFetchers).flatMap(authenticationFetcher -> authenticationFetcher.fetchAuthentication(request)).next().flatMap(authentication -> Mono.from(this.createResponse((Authentication)authentication, request, chain, (RouteMatch<?>)routeMatch))).switchIfEmpty(Flux.defer(() -> this.createResponse(null, request, chain, routeMatch)).next());
    }

    private Publisher<MutableHttpResponse<?>> createResponse(@Nullable Authentication authentication, HttpRequest<?> request, ServerFilterChain chain, RouteMatch<?> routeMatch) {
        request.setAttribute(AUTHENTICATION, (Object)authentication);
        this.logAuthenticationAttributes(authentication);
        return this.checkRules(request, chain, routeMatch, authentication);
    }

    private void logAuthenticationAttributes(@Nullable Authentication authentication) {
        if (authentication != null && LOG.isDebugEnabled()) {
            Map<String, Object> attributes = authentication.getAttributes();
            LOG.debug("Attributes: {}", (Object)attributes.entrySet().stream().map(entry -> (String)entry.getKey() + "=>" + entry.getValue().toString()).collect(Collectors.joining(", ")));
        }
    }

    protected Publisher<MutableHttpResponse<?>> checkRules(HttpRequest<?> request, ServerFilterChain chain, @Nullable RouteMatch<?> routeMatch, @Nullable Authentication authentication) {
        boolean forbidden = authentication != null;
        String method = request.getMethod().toString();
        String path = request.getPath();
        return Flux.fromIterable(this.securityRules).concatMap(rule -> Mono.from(rule.check(request, routeMatch, authentication)).defaultIfEmpty((Object)SecurityRuleResult.UNKNOWN).filter(result -> result != SecurityRuleResult.UNKNOWN).doOnSuccess(result -> this.logResult((SecurityRuleResult)((Object)((Object)result)), method, path, (Ordered)rule))).next().flatMapMany(result -> {
            if (result == SecurityRuleResult.REJECTED) {
                request.setAttribute(REJECTION, (Object)(forbidden ? HttpStatus.FORBIDDEN : HttpStatus.UNAUTHORIZED));
                return Mono.error((Throwable)new AuthorizationException(authentication));
            }
            if (result == SecurityRuleResult.ALLOWED) {
                return chain.proceed(request);
            }
            return Mono.empty();
        }).switchIfEmpty((Publisher)Flux.defer(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Authorized request {} {}. No rule provider authorized or rejected the request.", (Object)method, (Object)path);
            }
            if (routeMatch == null && !this.securityConfiguration.isRejectNotFound()) {
                return chain.proceed(request);
            }
            request.setAttribute(REJECTION, (Object)(forbidden ? HttpStatus.FORBIDDEN : HttpStatus.UNAUTHORIZED));
            return Mono.error((Throwable)new AuthorizationException(authentication));
        }));
    }

    private void logResult(SecurityRuleResult result, String method, String path, Ordered ordered) {
        if (LOG.isDebugEnabled()) {
            if (result == SecurityRuleResult.REJECTED) {
                LOG.debug("Unauthorized request {} {}. The rule provider {} rejected the request.", new Object[]{method, path, ordered.getClass().getName()});
            } else if (result == SecurityRuleResult.ALLOWED) {
                LOG.debug("Authorized request {} {}. The rule provider {} authorized the request.", new Object[]{method, path, ordered.getClass().getName()});
            }
        }
    }
}

