/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints.introspection;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.endpoints.introspection.IntrospectionProcessor;
import io.micronaut.security.endpoints.introspection.IntrospectionRequest;
import io.micronaut.security.endpoints.introspection.IntrospectionResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.reactivestreams.Publisher;

@Controller(value="${micronaut.security.endpoints.introspection.path:/token_info}")
@Secured(value={"isAuthenticated()"})
public class IntrospectionController {
    protected final IntrospectionProcessor processor;

    public IntrospectionController(IntrospectionProcessor processor) {
        this.processor = processor;
    }

    @Post
    @Consumes(value={"application/x-www-form-urlencoded"})
    @SingleResult
    public Publisher<IntrospectionResponse> tokenInfo(@NonNull @Body @Valid @NotNull IntrospectionRequest introspectionRequest, @NonNull HttpRequest<?> request) {
        return this.processor.introspect(introspectionRequest, request);
    }

    @Get
    @SingleResult
    public Publisher<IntrospectionResponse> echo(@NonNull Authentication authentication, @NonNull HttpRequest<?> request) {
        return this.processor.introspect(authentication, request);
    }
}

