/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.context.annotation.Primary;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.security.authentication.AuthenticationException;
import jakarta.inject.Singleton;

@Singleton
@Primary
@Produces
public class AuthenticationExceptionHandler
implements ExceptionHandler<AuthenticationException, MutableHttpResponse<?>> {
    private final ErrorResponseProcessor<?> errorResponseProcessor;

    public AuthenticationExceptionHandler(ErrorResponseProcessor<?> errorResponseProcessor) {
        this.errorResponseProcessor = errorResponseProcessor;
    }

    public MutableHttpResponse<?> handle(HttpRequest request, AuthenticationException exception) {
        return this.errorResponseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).cause((Throwable)exception).errorMessage(exception.getMessage()).build(), HttpResponse.status((HttpStatus)HttpStatus.UNAUTHORIZED, (String)exception.getMessage()));
    }
}

