/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.security.filters.SecurityFilter;
import jakarta.inject.Singleton;
import java.security.Principal;
import java.util.Optional;

@Singleton
public class PrincipalArgumentBinder
implements TypedRequestArgumentBinder<Principal> {
    public Argument<Principal> argumentType() {
        return Argument.of(Principal.class);
    }

    public ArgumentBinder.BindingResult<Principal> bind(ArgumentConversionContext<Principal> context, HttpRequest<?> source) {
        if (source.getAttributes().contains(SecurityFilter.KEY)) {
            Optional existing = source.getUserPrincipal();
            if (existing.isPresent()) {
                return () -> existing;
            }
            return ArgumentBinder.BindingResult.EMPTY;
        }
        return ArgumentBinder.BindingResult.UNSATISFIED;
    }
}

