/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.token.Claims;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.token.config.TokenConfiguration;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class DefaultRolesFinder
implements RolesFinder {
    private final TokenConfiguration tokenConfiguration;

    public DefaultRolesFinder(TokenConfiguration tokenConfiguration) {
        this.tokenConfiguration = tokenConfiguration;
    }

    @Override
    @NonNull
    public List<String> findInClaims(@NonNull Claims claims) {
        ArrayList<String> roles = new ArrayList<String>();
        Object rolesObject = claims.get(this.tokenConfiguration.getRolesName());
        if (rolesObject != null) {
            if (rolesObject instanceof Iterable) {
                for (Object o : (Iterable)rolesObject) {
                    roles.add(o.toString());
                }
            } else {
                roles.add(rolesObject.toString());
            }
        }
        return roles;
    }
}

