/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationUserDetailsAdapter;
import io.micronaut.security.authentication.Authenticator;
import io.micronaut.security.authentication.BasicAuthUtils;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.authentication.UsernamePasswordCredentials;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.token.config.TokenConfiguration;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Requires(property="micronaut.security.basic-auth.enabled", notEquals="false")
@Singleton
public class BasicAuthAuthenticationFetcher
implements AuthenticationFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthAuthenticationFetcher.class);
    private final Authenticator authenticator;
    private final TokenConfiguration configuration;

    public BasicAuthAuthenticationFetcher(Authenticator authenticator, TokenConfiguration configuration) {
        this.authenticator = authenticator;
        this.configuration = configuration;
    }

    @Override
    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        Optional credentials = request.getHeaders().getAuthorization().flatMap(BasicAuthUtils::parseCredentials);
        if (credentials.isPresent()) {
            Flux authenticationResponse = Flux.from(this.authenticator.authenticate(request, (AuthenticationRequest)credentials.get()));
            return authenticationResponse.switchMap(response -> {
                if (response.isAuthenticated()) {
                    UserDetails userDetails = response.getUserDetails().get();
                    return Flux.just((Object)new AuthenticationUserDetailsAdapter(userDetails, this.configuration.getRolesName(), this.configuration.getNameKey()));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not authenticate {}", (Object)((UsernamePasswordCredentials)credentials.get()).getUsername());
                }
                return Publishers.empty();
            });
        }
        return Publishers.empty();
    }
}

