/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.propagation;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.security.token.propagation.HttpHeaderTokenPropagatorConfiguration;
import io.micronaut.security.token.propagation.TokenPropagator;
import java.util.Optional;
import javax.inject.Singleton;

@Requires(property="micronaut.security.token.propagation.header.enabled", notEquals="false")
@Singleton
public class HttpHeaderTokenPropagator
implements TokenPropagator {
    protected final HttpHeaderTokenPropagatorConfiguration configuration;

    public HttpHeaderTokenPropagator(HttpHeaderTokenPropagatorConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void writeToken(MutableHttpRequest<?> request, String token) {
        request.header((CharSequence)this.configuration.getHeaderName(), (CharSequence)this.headerValue(token));
    }

    @Override
    public Optional<String> findToken(HttpRequest<?> request) {
        HttpHeaders headers = request.getHeaders();
        Optional authorizationHeader = headers.findFirst((CharSequence)this.configuration.getHeaderName());
        return authorizationHeader.flatMap(this::extractTokenFromAuthorization);
    }

    protected String headerValue(String token) {
        StringBuilder sb = new StringBuilder();
        String prefix = this.configuration.getPrefix();
        if (prefix != null) {
            sb.append(prefix);
            if (!prefix.endsWith(" ")) {
                sb.append(" ");
            }
        }
        sb.append(token);
        return sb.toString();
    }

    protected Optional<String> extractTokenFromAuthorization(String authorization) {
        String str;
        StringBuilder sb = new StringBuilder();
        String prefix = this.configuration.getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            sb.append(prefix);
            sb.append(" ");
        }
        if (authorization.startsWith(str = sb.toString())) {
            return Optional.of(authorization.substring(str.length()));
        }
        return Optional.empty();
    }

    public HttpHeaderTokenPropagatorConfiguration getConfiguration() {
        return this.configuration;
    }
}

