/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.utils;

import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.DefaultRolesFinder;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.security.utils.SecurityService;
import java.security.Principal;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultSecurityService
implements SecurityService {
    @Deprecated
    public static final String ROLES = "roles";
    private final RolesFinder rolesFinder;

    @Deprecated
    public DefaultSecurityService(TokenConfiguration tokenConfiguration) {
        this(new DefaultRolesFinder(tokenConfiguration));
    }

    @Inject
    public DefaultSecurityService(RolesFinder rolesFinder) {
        this.rolesFinder = rolesFinder;
    }

    @Override
    public Optional<String> username() {
        return this.getAuthentication().map(Principal::getName);
    }

    @Override
    public Optional<Authentication> getAuthentication() {
        return ServerRequestContext.currentRequest().flatMap(request -> request.getUserPrincipal(Authentication.class));
    }

    @Override
    public boolean isAuthenticated() {
        return this.getAuthentication().isPresent();
    }

    @Override
    public boolean hasRole(String role) {
        return this.getAuthentication().map(authentication -> this.rolesFinder.hasAnyRequiredRoles(Collections.singletonList(role), (Authentication)authentication)).orElse(false);
    }

    @Override
    @Deprecated
    public boolean hasRole(String role, String rolesKey) {
        if (role == null || rolesKey == null) {
            return false;
        }
        return this.hasRole(role);
    }
}

