/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.management.endpoint.EndpointSensitivityProcessor;
import io.micronaut.security.rules.InterceptUrlMapRule;
import io.micronaut.security.rules.SecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import java.util.Map;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SensitiveEndpointRule
implements SecurityRule {
    public static final Integer ORDER = 0;
    private static final Logger LOG = LoggerFactory.getLogger(InterceptUrlMapRule.class);
    protected final Map<ExecutableMethod, Boolean> endpointMethods;

    SensitiveEndpointRule(EndpointSensitivityProcessor endpointSensitivityProcessor) {
        this.endpointMethods = endpointSensitivityProcessor.getEndpointMethods();
    }

    @Override
    public SecurityRuleResult check(HttpRequest<?> request, @Nullable RouteMatch<?> routeMatch, @Nullable Map<String, Object> claims) {
        ExecutableMethod method;
        if (routeMatch instanceof MethodBasedRouteMatch && this.endpointMethods.containsKey(method = ((MethodBasedRouteMatch)routeMatch).getExecutableMethod())) {
            Boolean sensitive = this.endpointMethods.get(method);
            if (claims == null && sensitive.booleanValue()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The endpoint method [{}] is sensitive and no authentication was found. Rejecting the request", (Object)method);
                }
                return SecurityRuleResult.REJECTED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("The endpoint method [{}] is not sensitive or the request was authenticated. Allowing the request", (Object)method);
            }
            return SecurityRuleResult.ALLOWED;
        }
        return SecurityRuleResult.UNKNOWN;
    }

    public int getOrder() {
        return ORDER;
    }
}

