/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.util.StringUtils;
import io.micronaut.security.config.ForbiddenRedirectConfiguration;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RefreshRedirectConfiguration;
import io.micronaut.security.config.UnauthorizedRedirectConfiguration;
import javax.validation.constraints.NotBlank;

@ConfigurationProperties(value="micronaut.security.redirect")
public class RedirectConfigurationProperties
implements RedirectConfiguration {
    public static final String PREFIX = "micronaut.security.redirect";
    public static final String DEFAULT_LOGOUT_URL = "/";
    public static final String DEFAULT_LOGIN_SUCCESS = "/";
    public static final String DEFAULT_LOGIN_FAILURE = "/";
    public static final boolean DEFAULT_PRIOR_TO_LOGIN = false;
    @NotBlank
    @NonNull
    private String loginSuccess = "/";
    @NotBlank
    @NonNull
    private String loginFailure = "/";
    @NotBlank
    @NonNull
    private String logout = "/";
    private boolean priorToLogin = false;
    private UnauthorizedRedirectConfigurationProperties unauthorized = new UnauthorizedRedirectConfigurationProperties();
    private ForbiddenRedirectConfigurationProperties forbidden = new ForbiddenRedirectConfigurationProperties();
    private RefreshRedirectConfiguration refresh = new RefreshRedirectConfigurationProperties();

    @Override
    @NonNull
    public String getLoginSuccess() {
        return this.loginSuccess;
    }

    @Override
    @NonNull
    public String getLoginFailure() {
        return this.loginFailure;
    }

    public void setLoginSuccess(@NonNull String loginSuccess) {
        this.loginSuccess = loginSuccess;
    }

    public void setLoginFailure(@NonNull String loginFailure) {
        this.loginFailure = loginFailure;
    }

    @Override
    @NonNull
    public String getLogout() {
        return this.logout;
    }

    public void setLogout(@NonNull String logout) {
        if (StringUtils.isNotEmpty((CharSequence)logout)) {
            this.logout = logout;
        }
    }

    @Override
    @NonNull
    public UnauthorizedRedirectConfiguration getUnauthorized() {
        return this.unauthorized;
    }

    public void setUnauthorized(UnauthorizedRedirectConfigurationProperties unauthorized) {
        this.unauthorized = unauthorized;
    }

    @Override
    @NonNull
    public ForbiddenRedirectConfiguration getForbidden() {
        return this.forbidden;
    }

    public void setForbidden(ForbiddenRedirectConfigurationProperties forbidden) {
        this.forbidden = forbidden;
    }

    @Override
    @NonNull
    public RefreshRedirectConfiguration getRefresh() {
        return this.refresh;
    }

    public void setRefresh(RefreshRedirectConfigurationProperties refresh) {
        this.refresh = refresh;
    }

    public void setPriorToLogin(boolean priorToLogin) {
        this.priorToLogin = priorToLogin;
    }

    @Override
    public boolean isPriorToLogin() {
        return this.priorToLogin;
    }

    @ConfigurationProperties(value="refresh")
    public static class RefreshRedirectConfigurationProperties
    implements RefreshRedirectConfiguration {
        public static final Boolean DEFAULT_ENABLED = true;
        public static final String DEFAULT_REFRESH_URL = "/";
        private boolean enabled = DEFAULT_ENABLED;
        @NotBlank
        @NonNull
        private String url = "/";

        @Override
        @NonNull
        public String getUrl() {
            return this.url;
        }

        public void setUrl(@NonNull String url) {
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.url = url;
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    @ConfigurationProperties(value="forbidden")
    public static class ForbiddenRedirectConfigurationProperties
    implements ForbiddenRedirectConfiguration {
        public static final Boolean DEFAULT_ENABLED = true;
        public static final String DEFAULT_FORBIDDEN = "/";
        private boolean enabled = DEFAULT_ENABLED;
        @NotBlank
        @NonNull
        private String url = "/";

        @Override
        @NonNull
        public String getUrl() {
            return this.url;
        }

        public void setUrl(@NonNull String url) {
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.url = url;
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    @ConfigurationProperties(value="unauthorized")
    public static class UnauthorizedRedirectConfigurationProperties
    implements UnauthorizedRedirectConfiguration {
        public static final Boolean DEFAULT_ENABLED = true;
        public static final String DEFAULT_UNAUTHORIZED = "/";
        private boolean enabled = DEFAULT_ENABLED;
        @NotBlank
        @NonNull
        private String url = "/";

        @Override
        @NonNull
        public String getUrl() {
            return this.url;
        }

        public void setUrl(@NonNull String url) {
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.url = url;
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

