/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.password;

import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.SecureEndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.AuthenticationMethod;
import io.micronaut.security.oauth2.endpoint.DefaultSecureEndpoint;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.context.OauthPasswordTokenRequestContext;
import io.micronaut.security.oauth2.endpoint.token.response.OauthAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.TokenResponse;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Deprecated(since="4.8.0", forRemoval=true)
public class OauthPasswordAuthenticationProvider<T>
implements AuthenticationProvider<T> {
    private final TokenEndpointClient tokenEndpointClient;
    private final SecureEndpoint secureEndpoint;
    private final OauthClientConfiguration clientConfiguration;
    private final OauthAuthenticationMapper authenticationMapper;

    public OauthPasswordAuthenticationProvider(TokenEndpointClient tokenEndpointClient, OauthClientConfiguration clientConfiguration, OauthAuthenticationMapper authenticationMapper) {
        this.tokenEndpointClient = tokenEndpointClient;
        this.clientConfiguration = clientConfiguration;
        this.authenticationMapper = authenticationMapper;
        this.secureEndpoint = this.getTokenEndpoint(clientConfiguration);
    }

    public Publisher<AuthenticationResponse> authenticate(T requestContext, AuthenticationRequest<?, ?> authenticationRequest) {
        OauthPasswordTokenRequestContext context = new OauthPasswordTokenRequestContext(authenticationRequest, this.secureEndpoint, this.clientConfiguration);
        return Flux.from(this.tokenEndpointClient.sendRequest(context)).switchMap(response -> Flux.from(this.authenticationMapper.createAuthenticationResponse((TokenResponse)response, null)).map(AuthenticationResponse.class::cast));
    }

    protected SecureEndpoint getTokenEndpoint(OauthClientConfiguration clientConfiguration) {
        SecureEndpointConfiguration endpointConfiguration = clientConfiguration.getToken().orElseThrow(() -> new IllegalArgumentException("Token endpoint configuration is missing for provider [" + clientConfiguration.getName() + "]"));
        List<AuthenticationMethod> authMethodsSupported = Collections.singletonList(endpointConfiguration.getAuthMethod().orElse(AuthenticationMethod.CLIENT_SECRET_BASIC));
        String url = endpointConfiguration.getUrl().orElseThrow(() -> new IllegalArgumentException("Token endpoint URL is null for provider [" + clientConfiguration.getName() + "]"));
        return new DefaultSecureEndpoint(url, authMethodsSupported);
    }
}

