/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsClient;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsConfiguration;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.context.ClientCredentialsTokenRequestContext;
import io.micronaut.security.oauth2.endpoint.token.response.TokenResponse;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
public abstract class AbstractClientCredentialsClient
implements ClientCredentialsClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientCredentialsClient.class);
    private static final String NOSCOPE = "NOSCOPE";
    protected final TokenEndpointClient tokenEndpointClient;
    protected final OauthClientConfiguration oauthClientConfiguration;
    protected final Map<String, Publisher<TokenResponse>> scopeToPublisherMap = new ConcurrentHashMap<String, Publisher<TokenResponse>>();

    public AbstractClientCredentialsClient(@NonNull OauthClientConfiguration oauthClientConfiguration, @NonNull TokenEndpointClient tokenEndpointClient) {
        this.oauthClientConfiguration = oauthClientConfiguration;
        this.tokenEndpointClient = tokenEndpointClient;
    }

    public String getName() {
        return this.oauthClientConfiguration.getName();
    }

    @Override
    @NonNull
    public Publisher<TokenResponse> requestToken(@Nullable String scope) {
        return this.requestToken(scope, false);
    }

    @Override
    @NonNull
    public Publisher<TokenResponse> requestToken(@Nullable String scope, boolean force) {
        String resolvedScope = scope != null ? scope : NOSCOPE;
        return Flux.from((Publisher)this.scopeToPublisherMap.computeIfAbsent(resolvedScope, k -> this.cachedTokenResponseForScope(scope))).flatMap(response -> {
            if (!force && !this.isExpired((TokenResponse)response)) {
                return Mono.just((Object)response);
            }
            return Mono.from((Publisher)this.scopeToPublisherMap.computeIfPresent(resolvedScope, (s, tokenResponse) -> this.cachedTokenResponseForScope(scope)));
        }).doOnError(error -> this.scopeToPublisherMap.remove(resolvedScope));
    }

    @NonNull
    private Publisher<TokenResponse> cachedTokenResponseForScope(String scope) {
        return Flux.from(this.tokenEndpointClient.sendRequest(this.createTokenRequestContext(scope))).cache();
    }

    protected boolean isExpired(@Nullable TokenResponse tokenResponse) {
        if (tokenResponse == null) {
            return true;
        }
        return this.expirationDate(tokenResponse).map(expDate -> {
            boolean isExpired = this.isExpired((Date)expDate);
            if (isExpired && LOG.isTraceEnabled()) {
                LOG.trace("token: {} is expired", (Object)tokenResponse.getAccessToken());
            }
            return isExpired;
        }).orElse(true);
    }

    protected boolean isExpired(@NonNull Date expirationDate) {
        return expirationDate.getTime() - this.oauthClientConfiguration.getClientCredentials().map(ClientCredentialsConfiguration::getAdvancedExpiration).orElse(OauthClientConfiguration.DEFAULT_ADVANCED_EXPIRATION).toMillis() < new Date().getTime();
    }

    protected Optional<Date> expirationDate(@NonNull TokenResponse tokenResponse) {
        try {
            JWT jwt = JWTParser.parse((String)tokenResponse.getAccessToken());
            return Optional.ofNullable(jwt.getJWTClaimsSet().getExpirationTime());
        }
        catch (ParseException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("cannot parse access token {} to JWT", (Object)tokenResponse.getAccessToken());
            }
            return tokenResponse.getExpiresInDate();
        }
    }

    protected abstract ClientCredentialsTokenRequestContext createTokenRequestContext(@Nullable String var1);
}

