/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.response;

import io.micronaut.context.annotation.Requires;
import io.micronaut.security.oauth2.configuration.endpoints.EndSessionConfiguration;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import io.micronaut.security.oauth2.url.AbsoluteUrlBuilder;
import jakarta.inject.Singleton;
import java.net.URL;

@Requires(beans={AbsoluteUrlBuilder.class, EndSessionConfiguration.class})
@Singleton
public class DefaultEndSessionCallbackUrlBuilder<T>
implements EndSessionCallbackUrlBuilder<T> {
    private final AbsoluteUrlBuilder<T> absoluteUrlBuilder;
    private final EndSessionConfiguration endSessionConfiguration;

    public DefaultEndSessionCallbackUrlBuilder(AbsoluteUrlBuilder<T> absoluteUrlBuilder, EndSessionConfiguration endSessionConfiguration) {
        this.absoluteUrlBuilder = absoluteUrlBuilder;
        this.endSessionConfiguration = endSessionConfiguration;
    }

    @Override
    public URL build(T originating) {
        return this.absoluteUrlBuilder.buildUrl(originating, this.endSessionConfiguration.getRedirectUri());
    }
}

