/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.condition;

import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.oauth2.client.condition.AbstractCondition;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndpointConfiguration;
import io.micronaut.security.oauth2.grants.GrantType;

@Internal
public class OauthClientCondition
extends AbstractCondition {
    @Override
    @NonNull
    protected String getFailureMessagePrefix(@NonNull String name) {
        return "Skipped client creation for provider [" + name;
    }

    @Override
    protected boolean handleConfigurationEnabled(@NonNull OauthClientConfiguration clientConfiguration, @NonNull ConditionContext<?> context, @NonNull String failureMsgPrefix) {
        if (clientConfiguration.getAuthorization().flatMap(EndpointConfiguration::getUrl).isPresent()) {
            if (clientConfiguration.getToken().flatMap(EndpointConfiguration::getUrl).isPresent()) {
                if (clientConfiguration.getGrantType() == GrantType.AUTHORIZATION_CODE) {
                    return true;
                }
                context.fail(failureMsgPrefix + "] because grant type is not authorization code");
            } else {
                context.fail(failureMsgPrefix + "] because no token endpoint is configured");
            }
        } else {
            context.fail(failureMsgPrefix + "] because no authorization endpoint is configured");
        }
        return false;
    }
}

