/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.password;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.provider.ReactiveAuthenticationProvider;
import io.micronaut.security.authentication.provider.ReactiveAuthenticationProviderAdapter;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.password.OauthPasswordAuthenticationProvider;
import io.micronaut.security.oauth2.endpoint.token.request.password.OpenIdPasswordAuthenticationProvider;
import io.micronaut.security.oauth2.endpoint.token.request.password.PasswordGrantCondition;
import io.micronaut.security.oauth2.endpoint.token.response.DefaultOpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OauthAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdTokenResponseValidator;

@Factory
@Internal
class PasswordGrantFactory {
    PasswordGrantFactory() {
    }

    @EachBean(value=OauthClientConfiguration.class)
    @Requires(condition=PasswordGrantCondition.class)
    ReactiveAuthenticationProvider passwordGrantProvider(@Parameter OauthClientConfiguration clientConfiguration, @Parameter @Nullable OauthAuthenticationMapper authenticationMapper, @Parameter @Nullable OpenIdAuthenticationMapper openIdAuthenticationMapper, @Parameter @Nullable OpenIdProviderMetadata openIdProviderMetadata, TokenEndpointClient tokenEndpointClient, @Nullable DefaultOpenIdAuthenticationMapper defaultOpenIdAuthenticationMapper, @Nullable OpenIdTokenResponseValidator tokenResponseValidator) {
        if (clientConfiguration.getToken().isPresent()) {
            return new ReactiveAuthenticationProviderAdapter(new OauthPasswordAuthenticationProvider(tokenEndpointClient, clientConfiguration, authenticationMapper));
        }
        if (openIdAuthenticationMapper == null) {
            openIdAuthenticationMapper = defaultOpenIdAuthenticationMapper;
        }
        return new ReactiveAuthenticationProviderAdapter(new OpenIdPasswordAuthenticationProvider(clientConfiguration, openIdProviderMetadata, tokenEndpointClient, openIdAuthenticationMapper, tokenResponseValidator));
    }
}

