/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.token.Claims;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import jakarta.inject.Singleton;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requirements(value={@Requires(property="micronaut.security.authentication", value="idtoken"), @Requires(property="micronaut.security.token.jwt.claims-validators.openid-idtoken", notEquals="false")})
@Singleton
public class IdTokenClaimsValidator<T>
implements GenericJwtClaimsValidator<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(IdTokenClaimsValidator.class);
    protected static final String AUTHORIZED_PARTY = "azp";
    protected final Collection<OauthClientConfiguration> oauthClientConfigurations;

    public IdTokenClaimsValidator(Collection<OauthClientConfiguration> oauthClientConfigurations) {
        this.oauthClientConfigurations = oauthClientConfigurations;
    }

    public boolean validate(@NonNull Claims claims, @Nullable T request) {
        Optional<String> claimIssuerOptional = this.parseIssuerClaim(claims);
        if (!claimIssuerOptional.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("issuer claim not present");
            }
            return false;
        }
        String iss = claimIssuerOptional.get();
        Optional<List<String>> audiencesOptional = this.parseAudiences(claims);
        if (!audiencesOptional.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("audiences claim not present");
            }
            return false;
        }
        List<String> audiences = audiencesOptional.get();
        return this.validateIssuerAudienceAndAzp(claims, iss, audiences);
    }

    protected Optional<String> parseIssuerClaim(Claims claims) {
        return this.parseClaimString(claims, "iss");
    }

    protected Optional<Object> parseClaim(Claims claims, String claimName) {
        Object obj = claims.get(claimName);
        if (obj == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} claim not present", (Object)claimName);
            }
            return Optional.empty();
        }
        return Optional.of(obj);
    }

    protected Optional<String> parseClaimString(Claims claims, String claimName) {
        return this.parseClaim(claims, claimName).map(Object::toString);
    }

    protected Optional<List<String>> parseClaimList(Claims claims, String claimName) {
        Optional<Object> objectOptional = this.parseClaim(claims, claimName);
        if (!objectOptional.isPresent()) {
            return Optional.empty();
        }
        Object obj = objectOptional.get();
        ArrayList<String> result = new ArrayList<String>();
        if (obj instanceof List) {
            for (Object listObj : (List)obj) {
                result.add(listObj.toString());
            }
        } else {
            result.add(obj.toString());
        }
        return Optional.of(result);
    }

    protected Optional<List<String>> parseAudiences(Claims claims) {
        return this.parseClaimList(claims, "aud");
    }

    protected boolean validateIssuerAudienceAndAzp(@NonNull Claims claims, @NonNull String iss, @NonNull List<String> audiences) {
        return this.oauthClientConfigurations.stream().anyMatch(oauthClientConfiguration -> this.validateIssuerAudienceAndAzp(claims, iss, audiences, (OauthClientConfiguration)oauthClientConfiguration));
    }

    protected boolean validateIssuerAudienceAndAzp(@NonNull Claims claims, @NonNull String iss, @NonNull List<String> audiences, @NonNull OauthClientConfiguration oauthClientConfiguration) {
        Optional<OpenIdClientConfiguration> openIdClientConfigurationOptional = oauthClientConfiguration.getOpenid();
        if (openIdClientConfigurationOptional.isPresent()) {
            OpenIdClientConfiguration openIdClientConfiguration = openIdClientConfigurationOptional.get();
            return this.validateIssuerAudienceAndAzp(claims, iss, audiences, oauthClientConfiguration.getClientId(), openIdClientConfiguration);
        }
        return false;
    }

    protected boolean validateIssuerAudienceAndAzp(@NonNull Claims claims, @NonNull String iss, @NonNull List<String> audiences, @NonNull String clientId, @NonNull OpenIdClientConfiguration openIdClientConfiguration) {
        boolean matchesIssuer = this.matchesIssuer(openIdClientConfiguration, iss).orElse(false);
        if (!matchesIssuer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("configuration issuer '{}' does not match claim issuer '{}'", (Object)openIdClientConfiguration.getIssuer().map(URL::toString).orElse(""), (Object)iss);
            }
            return false;
        }
        boolean audiencesContainsClientId = audiences.contains(clientId);
        if (!audiencesContainsClientId) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("audiences '{}' does not contain client id '{}'", (Object)String.join((CharSequence)" ", audiences), (Object)clientId);
            }
            return false;
        }
        boolean azpValid = this.validateAzp(claims, clientId, audiences);
        if (!azpValid) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("azp not valid");
            }
            return false;
        }
        return true;
    }

    @NonNull
    protected Optional<Boolean> matchesIssuer(@NonNull OpenIdClientConfiguration openIdClientConfiguration, @NonNull String iss) {
        return openIdClientConfiguration.getIssuer().map(URL::toString).map(issuer -> issuer.equalsIgnoreCase(iss));
    }

    protected Optional<String> parseAzpClaim(Claims claims) {
        return this.parseClaimString(claims, AUTHORIZED_PARTY);
    }

    protected boolean validateAzp(@NonNull Claims claims, @NonNull String clientId, @NonNull List<String> audiences) {
        if (audiences.size() < 2) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} claim is not required for single audiences", (Object)AUTHORIZED_PARTY);
            }
            return true;
        }
        Optional<String> azpOptional = this.parseAzpClaim(claims);
        if (!azpOptional.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("azp claim not present");
            }
            return false;
        }
        String azp = azpOptional.get();
        boolean result = azp.equalsIgnoreCase(clientId);
        if (!result && LOG.isDebugEnabled()) {
            LOG.debug("{} claim does not match client id {}", (Object)AUTHORIZED_PARTY, (Object)clientId);
        }
        return result;
    }
}

