/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.pkce;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.CodeVerifierGenerator;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceConfiguration;
import jakarta.inject.Singleton;
import java.security.SecureRandom;
import java.util.Base64;

@Singleton
public class DefaultCodeVerifierGenerator
implements CodeVerifierGenerator {
    private final PkceConfiguration pkceConfiguration;

    public DefaultCodeVerifierGenerator(PkceConfiguration pkceConfiguration) {
        this.pkceConfiguration = pkceConfiguration;
    }

    @Override
    @NonNull
    public String generate() {
        return this.generateRandomCodeVerifier();
    }

    @NonNull
    private String generateRandomCodeVerifier() {
        return this.generateRandomCodeVerifier(new SecureRandom(), this.pkceConfiguration.getEntropy());
    }

    @NonNull
    private String generateRandomCodeVerifier(SecureRandom entropySource, int entropyBytes) {
        byte[] randomBytes = new byte[entropyBytes];
        entropySource.nextBytes(randomBytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
    }
}

