/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.metadata;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.oauth2.metadata.ProtectedResourceMetadata;
import io.micronaut.security.oauth2.metadata.ProtectedResourceMetadataProvider;

@Internal
@Requires(classes={HttpRequest.class})
@Controller
class ProtectedResourceMetadataController {
    private final ProtectedResourceMetadataProvider<HttpRequest<?>> protectedResourceMetadataProvider;

    ProtectedResourceMetadataController(ProtectedResourceMetadataProvider<HttpRequest<?>> protectedResourceMetadataProvider) {
        this.protectedResourceMetadataProvider = protectedResourceMetadataProvider;
    }

    @Secured(value={"isAnonymous()"})
    @Get(value="/.well-known/oauth-protected-resource")
    ProtectedResourceMetadata getProtectedResourceMetadata(HttpRequest<?> request) {
        return this.protectedResourceMetadataProvider.get(request);
    }

    @Secured(value={"isAnonymous()"})
    @Get(value="/.well-known/oauth-protected-resource{path:.+}")
    ProtectedResourceMetadata getProtectedResourceMetadata(@NonNull @PathVariable String path, HttpRequest<?> request) {
        return this.protectedResourceMetadataProvider.get(path, request);
    }
}

