/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.configuration;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.Toggleable;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.OauthAuthorizationEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.SecureEndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.AuthenticationMethod;
import io.micronaut.security.oauth2.endpoint.DefaultSecureEndpoint;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.AuthorizationServer;
import io.micronaut.security.oauth2.grants.GrantType;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public interface OauthClientConfiguration
extends Toggleable {
    @Deprecated(forRemoval=true)
    public static final AuthenticationMethod DEFAULT_AUTHENTICATION_METHOD = AuthenticationMethod.CLIENT_SECRET_POST;
    public static final String DEFAULT_AUTH_METHOD = "client_secret_post";
    public static final Duration DEFAULT_ADVANCED_EXPIRATION = Duration.ofSeconds(30L);

    @NonNull
    public String getName();

    @NonNull
    public String getClientId();

    @Nullable
    public String getClientSecret();

    @NonNull
    public List<String> getScopes();

    @NonNull
    public GrantType getGrantType();

    public Optional<SecureEndpointConfiguration> getToken();

    public Optional<OauthAuthorizationEndpointConfiguration> getAuthorization();

    @NonNull
    public Optional<ClientCredentialsConfiguration> getClientCredentials();

    public Optional<SecureEndpointConfiguration> getIntrospection();

    public Optional<SecureEndpointConfiguration> getRevocation();

    public Optional<OpenIdClientConfiguration> getOpenid();

    default public SecureEndpoint getTokenEndpoint() throws ConfigurationException {
        return this.getToken().map(secureEndpointConfiguration -> new DefaultSecureEndpoint((SecureEndpointConfiguration)secureEndpointConfiguration, DEFAULT_AUTH_METHOD)).orElseThrow(() -> new ConfigurationException("Oauth client " + this.getName() + " requires the token endpoint configuration to be set in configuration"));
    }

    @Nullable
    default public AuthorizationServer getAuthorizationServer() {
        return null;
    }

    default public boolean isProxyWellKnownOauthAuthorizationServer() {
        return false;
    }

    default public boolean isProxyWellKnownOpenidConfiguration() {
        return false;
    }
}

