/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.optim.StaticOptimizations;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.security.oauth2.client.DefaultOpenIdProviderMetadata;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadataFetcher;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpenIdProviderMetadataFetcher
implements OpenIdProviderMetadataFetcher {
    public static final Optimizations OPTIMIZATIONS = StaticOptimizations.get(Optimizations.class).orElse(new Optimizations(Collections.emptyMap()));
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOpenIdProviderMetadataFetcher.class);
    private final HttpClient client;
    private final OpenIdClientConfiguration openIdClientConfiguration;

    public DefaultOpenIdProviderMetadataFetcher(OpenIdClientConfiguration openIdClientConfiguration, @Client HttpClient client) {
        this.openIdClientConfiguration = openIdClientConfiguration;
        this.client = client;
    }

    @NonNull
    public String getName() {
        return this.openIdClientConfiguration.getName();
    }

    @Override
    @Blocking
    @NonNull
    public DefaultOpenIdProviderMetadata fetch() {
        return OPTIMIZATIONS.findMetadata(this.openIdClientConfiguration.getName()).map(Supplier::get).orElseGet(this.fetch(this.openIdClientConfiguration));
    }

    @NonNull
    private Supplier<DefaultOpenIdProviderMetadata> fetch(@NonNull OpenIdClientConfiguration openIdClientConfiguration) {
        return () -> openIdClientConfiguration.getIssuer().map(this::fetch).map(metadata -> {
            metadata.setName(openIdClientConfiguration.getName());
            return metadata;
        }).orElse(new DefaultOpenIdProviderMetadata(openIdClientConfiguration.getName()));
    }

    @NonNull
    private DefaultOpenIdProviderMetadata fetch(@NonNull URL issuer) {
        try {
            URL configurationUrl = new URL(issuer, StringUtils.prependUri((String)issuer.getPath(), (String)this.openIdClientConfiguration.getConfigurationPath()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending request for OpenID configuration for provider [{}] to URL [{}] running in thread {}", new Object[]{this.openIdClientConfiguration.getName(), configurationUrl, Thread.currentThread().getName()});
            }
            return (DefaultOpenIdProviderMetadata)this.client.toBlocking().retrieve(configurationUrl.toString(), DefaultOpenIdProviderMetadata.class);
        }
        catch (HttpClientException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            throw new DisabledBeanException("Bean of type " + DefaultOpenIdProviderMetadata.class.getName() + " with name quailfier " + this.openIdClientConfiguration.getName() + " is disabled. Failed to retrieve OpenID configuration for " + this.openIdClientConfiguration.getName());
        }
        catch (MalformedURLException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            throw new DisabledBeanException("Bean of type " + DefaultOpenIdProviderMetadata.class.getName() + " with name quailfier " + this.openIdClientConfiguration.getName() + " is disabled. Failure parsing issuer URL " + String.valueOf(issuer));
        }
    }

    public static class Optimizations {
        private final Map<String, Supplier<DefaultOpenIdProviderMetadata>> suppliers;

        public Optimizations(Map<String, Supplier<DefaultOpenIdProviderMetadata>> suppliers) {
            this.suppliers = suppliers;
        }

        public Optional<Supplier<DefaultOpenIdProviderMetadata>> findMetadata(String name) {
            return Optional.ofNullable(this.suppliers.get(name));
        }
    }
}

