/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.userinfo;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import java.util.Objects;

@Introspected
public record UserInfoClientTokenValidatorConfiguration(@NonNull String baseUrl, @NonNull String name, @NonNull String path) implements Named
{
    public static final String DEFAULT_PATH = "/userinfo";

    public UserInfoClientTokenValidatorConfiguration(String baseUrl, String name) {
        this(baseUrl, name, DEFAULT_PATH);
    }

    @NonNull
    public String getName() {
        return this.name();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String baseUrl;
        private String name;
        private String path = "/userinfo";

        @NonNull
        public Builder baseUrl(@NonNull String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder path(@NonNull String path) {
            this.path = path;
            return this;
        }

        @NonNull
        public UserInfoClientTokenValidatorConfiguration build() {
            Objects.requireNonNull(this.baseUrl, "baseUrl must be set");
            Objects.requireNonNull(this.name, "name must be set");
            if (this.path == null) {
                this.path = UserInfoClientTokenValidatorConfiguration.DEFAULT_PATH;
            }
            return new UserInfoClientTokenValidatorConfiguration(this.baseUrl, this.name, this.path);
        }
    }
}

