/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.userinfo;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.userinfo.UserInfoClientTokenValidator;
import io.micronaut.security.oauth2.endpoint.userinfo.UserInfoClientTokenValidatorConfiguration;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URL;

@Factory
@Internal
final class UserInfoClientFactory {
    private final BeanContext beanContext;
    private final HttpClientConfiguration httpClientConfiguration;

    UserInfoClientFactory(BeanContext beanContext, HttpClientConfiguration httpClientConfiguration) {
        this.beanContext = beanContext;
        this.httpClientConfiguration = httpClientConfiguration;
    }

    @EachBean(value=OpenIdProviderMetadata.class)
    @Prototype
    UserInfoClientTokenValidatorConfiguration createUserInfoClient(OpenIdProviderMetadata metadata) {
        String userInfoEndpoint = this.userInfoEndpointViaConfiguration(metadata.getName());
        if (StringUtils.isEmpty((CharSequence)userInfoEndpoint)) {
            userInfoEndpoint = metadata.getUserinfoEndpoint();
        }
        return this.createUserInfoClientWithUrl(userInfoEndpoint, metadata.getName());
    }

    @EachBean(value=UserInfoClientTokenValidatorConfiguration.class)
    @Singleton
    UserInfoClientTokenValidator createUserInfoClient(UserInfoClientTokenValidatorConfiguration config) {
        try {
            HttpClient httpClient = (HttpClient)this.beanContext.createBean(HttpClient.class, new Object[]{new URL(config.baseUrl()), this.httpClientConfiguration});
            return new UserInfoClientTokenValidator(config.name(), httpClient, config.path());
        }
        catch (MalformedURLException e) {
            throw new DisabledBeanException("Malformed URL Exception for UserInfo endpoint " + config.baseUrl() + " for " + config.getName());
        }
    }

    @Nullable
    private String userInfoEndpointViaConfiguration(String nameQualifier) {
        return this.beanContext.findBean(OpenIdClientConfiguration.class, Qualifiers.byName((String)nameQualifier)).flatMap(OpenIdClientConfiguration::getUserInfo).flatMap(EndpointConfiguration::getUrl).orElse(null);
    }

    @NonNull
    private UserInfoClientTokenValidatorConfiguration createUserInfoClientWithUrl(@Nullable String userInfoEndpoint, @NonNull String name) {
        if (StringUtils.isEmpty((CharSequence)userInfoEndpoint)) {
            throw new DisabledBeanException("UserInfo endpoint not set for " + name);
        }
        try {
            URL url = new URL(userInfoEndpoint);
            String path = url.getPath();
            String baseUrl = url.toString().substring(0, url.toString().indexOf(path));
            return UserInfoClientTokenValidatorConfiguration.builder().baseUrl(baseUrl).name(name).path(path).build();
        }
        catch (MalformedURLException e) {
            throw new DisabledBeanException("Malformed URL Exception for UserInfo endpoint " + userInfoEndpoint + " for " + name);
        }
    }
}

