/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.request;

import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.endsession.request.AbstractEndSessionRequest;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakEndSessionEndpoint
extends AbstractEndSessionRequest {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakEndSessionEndpoint.class);
    private static final String PARAM_POST_LOGOUT_REDIRECT_URI = "post_logout_redirect_uri";
    private static final String PARAM_ID_TOKEN_HINT = "id_token_hint";
    private static final String PARAM_CLIENT_ID = "client_id";
    private static final String LOGOUT_URI = "/protocol/openid-connect/logout";

    public KeycloakEndSessionEndpoint(EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder, OauthClientConfiguration clientConfiguration, Supplier<OpenIdProviderMetadata> providerMetadata) {
        super(endSessionCallbackUrlBuilder, clientConfiguration, providerMetadata);
    }

    @Override
    protected String getUrl() {
        OpenIdProviderMetadata openIdProviderMetadata = (OpenIdProviderMetadata)this.providerMetadataSupplier.get();
        return openIdProviderMetadata.getEndSessionEndpoint() != null ? openIdProviderMetadata.getEndSessionEndpoint() : StringUtils.prependUri((String)openIdProviderMetadata.getIssuer(), (String)LOGOUT_URI);
    }

    @Override
    protected Map<String, Object> getArguments(HttpRequest<?> originating, Authentication authentication) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        String redirectUri = this.getRedirectUri(originating);
        if (StringUtils.isNotEmpty((CharSequence)redirectUri)) {
            arguments.put(PARAM_POST_LOGOUT_REDIRECT_URI, redirectUri);
        }
        arguments.put(PARAM_CLIENT_ID, this.clientConfiguration.getClientId());
        if (authentication != null) {
            Object idToken = authentication.getAttributes().get("openIdToken");
            if (idToken != null) {
                arguments.put(PARAM_ID_TOKEN_HINT, idToken.toString());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("ID Token not found in Authentication attributes. Logout will require user confirmation. Ensure 'micronaut.security.oauth2.openid.additional-claims.jwt=true' is configured.");
            }
        }
        return arguments;
    }
}

