/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.request;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.endpoint.endsession.request.Auth0EndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.AuthorizationServer;
import io.micronaut.security.oauth2.endpoint.endsession.request.AuthorizationServerResolver;
import io.micronaut.security.oauth2.endpoint.endsession.request.AwsCognitoEndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.DefaultAuthorizationServerResolver;
import io.micronaut.security.oauth2.endpoint.endsession.request.EndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.KeycloakEndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.MicrosoftEndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.OktaEndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import io.micronaut.security.token.reader.TokenResolver;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URL;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EndSessionEndpointResolver {
    private static final Logger LOG = LoggerFactory.getLogger(EndSessionEndpointResolver.class);
    private final BeanContext beanContext;
    private final AuthorizationServerResolver authorizationServerResolver;

    @Inject
    public EndSessionEndpointResolver(BeanContext beanContext, AuthorizationServerResolver authorizationServerResolver) {
        this.beanContext = beanContext;
        this.authorizationServerResolver = authorizationServerResolver;
    }

    @Deprecated
    public EndSessionEndpointResolver(BeanContext beanContext) {
        this(beanContext, new DefaultAuthorizationServerResolver());
    }

    public Optional<EndSessionEndpoint> resolve(OauthClientConfiguration oauthClientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder) {
        return this.resolve(oauthClientConfiguration, () -> openIdProviderMetadata, endSessionCallbackUrlBuilder);
    }

    public Optional<EndSessionEndpoint> resolve(OauthClientConfiguration oauthClientConfiguration, Supplier<OpenIdProviderMetadata> openIdProviderMetadata, EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder) {
        String issuer;
        EndSessionEndpoint endSessionEndpoint;
        String providerName = oauthClientConfiguration.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving the end session endpoint for provider [{}]. Looking for a bean with the provider name qualifier", (Object)providerName);
        }
        if ((endSessionEndpoint = (EndSessionEndpoint)this.beanContext.findBean(EndSessionEndpoint.class, Qualifiers.byName((String)providerName)).orElse(null)) != null) {
            return Optional.of(endSessionEndpoint);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No EndSessionEndpoint bean found with a name qualifier of [{}]", (Object)providerName);
        }
        if ((issuer = (String)oauthClientConfiguration.getOpenid().flatMap(OpenIdClientConfiguration::getIssuer).map(URL::toString).orElse(null)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No EndSessionEndpoint can be resolved. Issuer is null for provider [{}]", (Object)providerName);
            }
            return Optional.empty();
        }
        return this.getEndSessionEndpoint(oauthClientConfiguration, openIdProviderMetadata, endSessionCallbackUrlBuilder, providerName, issuer);
    }

    @Nullable
    static AuthorizationServer authorizationServer(@NonNull AuthorizationServerResolver authorizationServerResolver, @NonNull OauthClientConfiguration oauthClientConfiguration, @NonNull String issuer) {
        AuthorizationServer authorizationServer = oauthClientConfiguration.getAuthorizationServer();
        if (authorizationServer == null) {
            return authorizationServerResolver.resolve(issuer).orElse(null);
        }
        return authorizationServer;
    }

    @NonNull
    private Optional<EndSessionEndpoint> getEndSessionEndpoint(OauthClientConfiguration oauthClientConfiguration, Supplier<OpenIdProviderMetadata> openIdProviderMetadata, EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder, @NonNull String providerName, @NonNull String issuer) {
        AuthorizationServer authorizationServer = EndSessionEndpointResolver.authorizationServer(this.authorizationServerResolver, oauthClientConfiguration, issuer);
        if (authorizationServer == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No EndSessionEndpoint can be resolved. no authorization-server is set for [{}] and the issuer does not match any of the providers supported by default", (Object)providerName);
            }
            return Optional.empty();
        }
        switch (authorizationServer) {
            case MICROSOFT: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved the MicrosoftEndSessionEndpoint for provider [{}]", (Object)providerName);
                }
                return Optional.of(new MicrosoftEndSessionEndpoint(endSessionCallbackUrlBuilder, oauthClientConfiguration, openIdProviderMetadata));
            }
            case ORACLE_CLOUD: 
            case OKTA: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved auth server {} for provider [{}]", (Object)authorizationServer, (Object)providerName);
                }
                return this.oktaEndSessionEndpoint(oauthClientConfiguration, openIdProviderMetadata, endSessionCallbackUrlBuilder);
            }
            case COGNITO: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved the AwsCognitoEndSessionEndpoint for provider [{}]", (Object)providerName);
                }
                return Optional.of(new AwsCognitoEndSessionEndpoint(endSessionCallbackUrlBuilder, oauthClientConfiguration, openIdProviderMetadata));
            }
            case AUTH0: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved the Auth0EndSessionEndpoint for provider [{}]", (Object)providerName);
                }
                return Optional.of(new Auth0EndSessionEndpoint(endSessionCallbackUrlBuilder, oauthClientConfiguration, openIdProviderMetadata));
            }
            case KEYCLOAK: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved the KeycloakEndSessionEndpoint for provider [{}]", (Object)providerName);
                }
                return Optional.of(new KeycloakEndSessionEndpoint(endSessionCallbackUrlBuilder, oauthClientConfiguration, openIdProviderMetadata));
            }
        }
        return Optional.empty();
    }

    @NonNull
    private Optional<EndSessionEndpoint> oktaEndSessionEndpoint(OauthClientConfiguration oauthClientConfiguration, Supplier<OpenIdProviderMetadata> openIdProviderMetadata, EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder) {
        SecurityConfiguration securityConfiguration = (SecurityConfiguration)this.beanContext.getBean(SecurityConfiguration.class);
        TokenResolver tokenResolver = (TokenResolver)this.beanContext.getBean(TokenResolver.class);
        return Optional.of(new OktaEndSessionEndpoint(endSessionCallbackUrlBuilder, oauthClientConfiguration, openIdProviderMetadata, securityConfiguration, tokenResolver));
    }
}

