/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.proxy;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.proxy.WellKnownProxySettings;
import java.net.URL;
import java.util.Collection;

@Internal
final class WellKnownProxyFilterCondition
implements Condition {
    WellKnownProxyFilterCondition() {
    }

    public boolean matches(ConditionContext context) {
        return WellKnownProxyFilterCondition.issuer(context.getBeansOfType(OauthClientConfiguration.class)) != null;
    }

    @Nullable
    static WellKnownProxySettings issuer(@NonNull Collection<OauthClientConfiguration> oauthClientConfigurations) {
        if (CollectionUtils.isEmpty(oauthClientConfigurations)) {
            return null;
        }
        for (OauthClientConfiguration config : oauthClientConfigurations) {
            URL issuer;
            if (!config.isProxyWellKnownOpenidConfiguration() && !config.isProxyWellKnownOauthAuthorizationServer() || (issuer = WellKnownProxyFilterCondition.issuer(config)) == null) continue;
            return new WellKnownProxySettings(issuer, config.isProxyWellKnownOauthAuthorizationServer(), config.isProxyWellKnownOpenidConfiguration());
        }
        return null;
    }

    @Nullable
    static URL issuer(OauthClientConfiguration oauthClientConfiguration) {
        return oauthClientConfiguration.getOpenid().flatMap(OpenIdClientConfiguration::getIssuer).orElse(null);
    }
}

