/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.metadata;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.security.authentication.WwwAuthenticateChallenge;
import io.micronaut.security.authentication.WwwAuthenticateChallengeProvider;
import jakarta.inject.Singleton;

@Requirements(value={@Requires(classes={HttpRequest.class, HttpHostResolver.class}), @Requires(beans={HttpHostResolver.class}), @Requires(property="micronaut.security.oauth2.protected-resource-metadata.www-authenticate", notEquals="false", defaultValue="true")})
@Internal
@Singleton
class ResourceMetadataWwwAuthenticateChallengeProvider
implements WwwAuthenticateChallengeProvider<HttpRequest<?>> {
    private static final String PARAM_RESOURCE_METADATA = "resource_metadata";
    private static final String SLASH = "/";
    private final HttpHostResolver httpHostResolver;

    ResourceMetadataWwwAuthenticateChallengeProvider(HttpHostResolver httpHostResolver) {
        this.httpHostResolver = httpHostResolver;
    }

    @NonNull
    public String getWwwAuthenticateChallenge(@Nullable HttpRequest<?> request) {
        return WwwAuthenticateChallenge.builder().authScheme("Bearer").param(PARAM_RESOURCE_METADATA, (Object)this.resourceMetadata(request)).build().toString();
    }

    @NonNull
    private String resourceMetadata(@Nullable HttpRequest<?> request) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.httpHostResolver.resolve(request));
        sb.append("/.well-known/oauth-protected-resource");
        if (request != null && StringUtils.isNotEmpty((CharSequence)request.getPath()) && !request.getPath().equals(SLASH)) {
            sb.append(request.getPath());
        }
        return sb.toString();
    }
}

