/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
public record ProtectedResourceMetadata(@NonNull String resource, @JsonProperty(value="authorization_servers") @Nullable List<String> authorizationServers, @JsonProperty(value="jwks_uri") @Nullable String jwksUri, @JsonProperty(value="scopes_supported") @Nullable List<String> scopesSupported, @JsonProperty(value="bearer_methods_supported") @Nullable List<String> bearerMethodsSupported, @JsonProperty(value="resource_signing_alg_values_supported") @Nullable List<String> resourceSigningAlgValuesSupported, @JsonProperty(value="resource_name") String resourceName, @JsonProperty(value="resource_documentation") @Nullable String resourceDocumentation, @JsonProperty(value="resource_policy_uri") @Nullable String resourcePolicyUri, @JsonProperty(value="resource_tos_uri") @Nullable String resourceTosUri, @JsonProperty(value="tls_client_certificate_bound_access_tokens") @Nullable Boolean tlsClientCertificateBoundAccessTokens, @JsonProperty(value="authorization_details_types_supported") @Nullable List<String> authorizationDetailsTypesSupported, @JsonProperty(value="dpop_signing_alg_values_supported") @Nullable List<String> dpopSigningAlgValuesSupported, @JsonProperty(value="dpop_bound_access_tokens_required") Boolean dpopBoundAccessTokensRequired) {
    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String resource;
        private List<String> authorizationServers;
        private String jwksUri;
        private List<String> scopesSupported;
        private List<String> bearerMethodsSupported;
        private List<String> resourceSigningAlgValuesSupported;
        private String resourceName;
        private String resourceDocumentation;
        private String resourcePolicyUri;
        private String resourceTosUri;
        private Boolean tlsClientCertificateBoundAccessTokens;
        private List<String> authorizationDetailsTypesSupported;
        private List<String> dpopSigningAlgValuesSupported;
        private Boolean dpopBoundAccessTokensRequired;

        @NonNull
        public Builder resource(@NonNull String resource) {
            this.resource = resource;
            return this;
        }

        @NonNull
        public Builder authorizationServers(@Nullable List<String> authorizationServers) {
            this.authorizationServers = authorizationServers;
            return this;
        }

        @NonNull
        public Builder authorizationServer(@NonNull String issuer) {
            if (this.authorizationServers == null) {
                this.authorizationServers = new ArrayList<String>();
            }
            this.authorizationServers.add(issuer);
            return this;
        }

        @NonNull
        public Builder authorizationServer(@NonNull URL issuer) {
            return this.authorizationServer(issuer.toString());
        }

        @NonNull
        public Builder jwksUri(@Nullable String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        @NonNull
        public Builder scopesSupported(@Nullable List<String> scopesSupported) {
            this.scopesSupported = scopesSupported;
            return this;
        }

        @NonNull
        public Builder bearerMethodsSupported(@Nullable List<String> bearerMethodsSupported) {
            this.bearerMethodsSupported = bearerMethodsSupported;
            return this;
        }

        @NonNull
        public Builder resourceSigningAlgValuesSupported(@Nullable List<String> resourceSigningAlgValuesSupported) {
            this.resourceSigningAlgValuesSupported = resourceSigningAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @NonNull
        public Builder resourceDocumentation(@Nullable String resourceDocumentation) {
            this.resourceDocumentation = resourceDocumentation;
            return this;
        }

        @NonNull
        public Builder resourcePolicyUri(@Nullable String resourcePolicyUri) {
            this.resourcePolicyUri = resourcePolicyUri;
            return this;
        }

        @NonNull
        public Builder resourceTosUri(@Nullable String resourceTosUri) {
            this.resourceTosUri = resourceTosUri;
            return this;
        }

        @NonNull
        public Builder tlsClientCertificateBoundAccessTokens(@Nullable Boolean tlsClientCertificateBoundAccessTokens) {
            this.tlsClientCertificateBoundAccessTokens = tlsClientCertificateBoundAccessTokens;
            return this;
        }

        @NonNull
        public Builder authorizationDetailsTypesSupported(@Nullable List<String> authorizationDetailsTypesSupported) {
            this.authorizationDetailsTypesSupported = authorizationDetailsTypesSupported;
            return this;
        }

        @NonNull
        public Builder dpopSigningAlgValuesSupported(@Nullable List<String> dpopSigningAlgValuesSupported) {
            this.dpopSigningAlgValuesSupported = dpopSigningAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder dpopBoundAccessTokensRequired(Boolean dpopBoundAccessTokensRequired) {
            this.dpopBoundAccessTokensRequired = dpopBoundAccessTokensRequired;
            return this;
        }

        @NonNull
        public ProtectedResourceMetadata build() {
            Objects.requireNonNull(this.resource, "resource must not be null");
            return new ProtectedResourceMetadata(this.resource, this.authorizationServers, this.jwksUri, this.scopesSupported, this.bearerMethodsSupported, this.resourceSigningAlgValuesSupported, this.resourceName, this.resourceDocumentation, this.resourcePolicyUri, this.resourceTosUri, this.tlsClientCertificateBoundAccessTokens, this.authorizationDetailsTypesSupported, this.dpopSigningAlgValuesSupported, this.dpopBoundAccessTokensRequired);
        }
    }
}

