/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.context;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.token.request.context.AbstractTokenRequestContext;
import io.micronaut.security.oauth2.endpoint.token.response.TokenErrorResponse;
import io.micronaut.security.oauth2.endpoint.token.response.TokenResponse;
import io.micronaut.security.oauth2.grants.AuthorizationCodeGrant;
import java.util.Map;

public class OauthCodeTokenRequestContext
extends AbstractTokenRequestContext<Map<String, String>, TokenResponse> {
    private final AuthorizationResponse authorizationResponse;
    @Nullable
    private final String codeVerifier;

    public OauthCodeTokenRequestContext(AuthorizationResponse authorizationResponse, SecureEndpoint tokenEndpoint, OauthClientConfiguration clientConfiguration, @Nullable String codeVerifier) {
        super(MediaType.APPLICATION_FORM_URLENCODED_TYPE, tokenEndpoint, clientConfiguration);
        this.authorizationResponse = authorizationResponse;
        this.codeVerifier = codeVerifier;
    }

    @Override
    public Map<String, String> getGrant() {
        AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant();
        codeGrant.setCode(this.authorizationResponse.getCode());
        State state = this.authorizationResponse.getState();
        codeGrant.setCodeVerifier(this.getCodeVerifier());
        if (state != null && state.getRedirectUri() != null) {
            codeGrant.setRedirectUri(this.authorizationResponse.getState().getRedirectUri().toString());
        }
        return codeGrant.toMap();
    }

    @Override
    public Argument<TokenResponse> getResponseType() {
        return Argument.of(TokenResponse.class);
    }

    @Override
    public Argument<?> getErrorResponseType() {
        return Argument.of(TokenErrorResponse.class);
    }

    @Nullable
    public String getCodeVerifier() {
        return this.codeVerifier;
    }
}

