/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.request;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.endsession.request.AbstractEndSessionRequest;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

@Internal
final class MicrosoftEndSessionEndpoint
extends AbstractEndSessionRequest {
    private static final String PARAM_POST_LOGOUT_REDIRECT_URI = "post_logout_redirect_uri";
    private static final String CLAIM_LOGIN_HINT = "login_hint";
    private static final String CLAIM_LOGOUT_HINT = "logout_hint";

    MicrosoftEndSessionEndpoint(EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder, OauthClientConfiguration clientConfiguration, Supplier<OpenIdProviderMetadata> providerMetadata) {
        super(endSessionCallbackUrlBuilder, clientConfiguration, providerMetadata);
    }

    @Override
    protected String getUrl() {
        return ((OpenIdProviderMetadata)this.providerMetadataSupplier.get()).getEndSessionEndpoint();
    }

    @Override
    protected Map<String, Object> getArguments(HttpRequest<?> originating, Authentication authentication) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(PARAM_POST_LOGOUT_REDIRECT_URI, this.getRedirectUri(originating));
        Object loginHint = authentication.getAttributes().get(CLAIM_LOGIN_HINT);
        if (loginHint != null) {
            arguments.put(CLAIM_LOGOUT_HINT, loginHint);
        }
        return arguments;
    }
}

