/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.AuthenticationMode;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.config.AuthenticationModeConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdAdditionalClaimsConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdTokenResponse;
import io.micronaut.security.token.Claims;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@Requires(configuration="io.micronaut.security.token.jwt")
public class DefaultOpenIdAuthenticationMapper
implements OpenIdAuthenticationMapper {
    private final OpenIdAdditionalClaimsConfiguration openIdAdditionalClaimsConfiguration;
    private final AuthenticationModeConfiguration authenticationModeConfiguration;

    public DefaultOpenIdAuthenticationMapper(OpenIdAdditionalClaimsConfiguration openIdAdditionalClaimsConfiguration, AuthenticationModeConfiguration authenticationModeConfiguration) {
        this.openIdAdditionalClaimsConfiguration = openIdAdditionalClaimsConfiguration;
        this.authenticationModeConfiguration = authenticationModeConfiguration;
    }

    @Override
    @NonNull
    public Publisher<AuthenticationResponse> createAuthenticationResponse(String providerName, OpenIdTokenResponse tokenResponse, OpenIdClaims openIdClaims, @Nullable State state) {
        Map<String, Object> claims = this.buildAttributes(providerName, tokenResponse, openIdClaims);
        List<String> roles = this.getRoles(providerName, tokenResponse, openIdClaims);
        String username = this.getUsername(providerName, tokenResponse, openIdClaims);
        return Flux.just((Object)AuthenticationResponse.success((String)username, roles, claims));
    }

    protected Map<String, Object> buildAttributes(String providerName, OpenIdTokenResponse tokenResponse, OpenIdClaims openIdClaims) {
        boolean idtokenAuthentication;
        HashMap<String, Object> claims = new HashMap<String, Object>(openIdClaims.getClaims());
        Claims.ALL_CLAIMS.forEach(claims::remove);
        claims.put("oauth2Provider", providerName);
        boolean bl = idtokenAuthentication = this.authenticationModeConfiguration.getAuthentication() != null && this.authenticationModeConfiguration.getAuthentication() == AuthenticationMode.IDTOKEN;
        if (idtokenAuthentication || this.openIdAdditionalClaimsConfiguration.isJwt()) {
            claims.put("openIdToken", tokenResponse.getIdToken());
        }
        if (idtokenAuthentication || this.openIdAdditionalClaimsConfiguration.isAccessToken()) {
            claims.put("accessToken", tokenResponse.getAccessToken());
        }
        if (idtokenAuthentication || this.openIdAdditionalClaimsConfiguration.isRefreshToken() && tokenResponse.getRefreshToken() != null) {
            claims.put("refreshToken", tokenResponse.getRefreshToken());
        }
        return claims;
    }

    protected List<String> getRoles(String providerName, OpenIdTokenResponse tokenResponse, OpenIdClaims openIdClaims) {
        return Collections.emptyList();
    }

    protected String getUsername(String providerName, OpenIdTokenResponse tokenResponse, OpenIdClaims openIdClaims) {
        return openIdClaims.getSubject();
    }
}

