/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.request;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.oauth2.endpoint.endsession.request.AuthorizationServer;
import io.micronaut.security.oauth2.endpoint.endsession.request.AuthorizationServerResolver;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Internal
@Singleton
final class DefaultAuthorizationServerResolver
implements AuthorizationServerResolver {
    private static final String ISSUER_PART_OKTA = "okta";
    private static final String ISSUER_PART_ORACLE_CLOUD = "oraclecloud";
    private static final String ISSUER_PART_MICROSOFT = "login.microsoftonline.com";
    private static final String ISSUER_PART_COGNITO = "cognito";
    private static final String ISSUER_PART_AUTH0 = "auth0";
    private static final String ISSUER_PART_KEYCLOAK = "/auth/realms/";
    private static final Map<String, AuthorizationServer> cache = new ConcurrentHashMap<String, AuthorizationServer>();

    DefaultAuthorizationServerResolver() {
    }

    @Override
    @NonNull
    public Optional<AuthorizationServer> resolve(@NonNull String issuer) {
        return Optional.ofNullable(cache.computeIfAbsent(issuer, DefaultAuthorizationServerResolver::infer));
    }

    @Nullable
    static AuthorizationServer infer(@NonNull String issuer) {
        if (issuer.contains(ISSUER_PART_MICROSOFT)) {
            return AuthorizationServer.MICROSOFT;
        }
        if (issuer.contains(ISSUER_PART_ORACLE_CLOUD)) {
            return AuthorizationServer.ORACLE_CLOUD;
        }
        if (issuer.contains(ISSUER_PART_OKTA)) {
            return AuthorizationServer.OKTA;
        }
        if (issuer.contains(ISSUER_PART_COGNITO)) {
            return AuthorizationServer.COGNITO;
        }
        if (issuer.contains(ISSUER_PART_AUTH0)) {
            return AuthorizationServer.AUTH0;
        }
        if (issuer.contains(ISSUER_PART_KEYCLOAK)) {
            return AuthorizationServer.KEYCLOAK;
        }
        return null;
    }
}

