/*
 * Copyright 2017-2023 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.security.oauth2.configuration.endpoints;

import java.util.Optional;

/**
 * Default implementation of {@link EndpointConfiguration}.
 *
 * @author James Kleeh
 * @since 1.2.0
 */
public class DefaultEndpointConfiguration implements EndpointConfiguration {

    private String url;

    @Override
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    /**
     * @param url The endpoint URL
     */
    public void setUrl(String url) {
        this.url = url;
    }
}
