/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.password;

import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.provider.ReactiveAuthenticationProvider;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.SecureEndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.DefaultSecureEndpoint;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.context.OauthPasswordTokenRequestContext;
import io.micronaut.security.oauth2.endpoint.token.response.OauthAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.TokenResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ReactiveOauthPasswordAuthenticationProvider<T, I, S>
implements ReactiveAuthenticationProvider<T, I, S> {
    private final TokenEndpointClient tokenEndpointClient;
    private final SecureEndpoint secureEndpoint;
    private final OauthClientConfiguration clientConfiguration;
    private final OauthAuthenticationMapper authenticationMapper;

    public ReactiveOauthPasswordAuthenticationProvider(TokenEndpointClient tokenEndpointClient, OauthClientConfiguration clientConfiguration, OauthAuthenticationMapper authenticationMapper) {
        this.tokenEndpointClient = tokenEndpointClient;
        this.clientConfiguration = clientConfiguration;
        this.authenticationMapper = authenticationMapper;
        this.secureEndpoint = this.getTokenEndpoint(clientConfiguration);
    }

    public Publisher<AuthenticationResponse> authenticate(T requestContext, AuthenticationRequest<I, S> authenticationRequest) {
        OauthPasswordTokenRequestContext context = new OauthPasswordTokenRequestContext(authenticationRequest, this.secureEndpoint, this.clientConfiguration);
        return Flux.from(this.tokenEndpointClient.sendRequest(context)).flatMap(response -> Flux.from(this.authenticationMapper.createAuthenticationResponse((TokenResponse)response, null)));
    }

    protected SecureEndpoint getTokenEndpoint(OauthClientConfiguration clientConfiguration) {
        SecureEndpointConfiguration endpointConfiguration = clientConfiguration.getToken().orElseThrow(() -> new IllegalArgumentException("Token endpoint configuration is missing for provider [" + clientConfiguration.getName() + "]"));
        return new DefaultSecureEndpoint(endpointConfiguration, "client_secret_basic");
    }
}

