/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.routes;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.server.util.locale.HttpLocaleResolver;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.event.LoginFailedEvent;
import io.micronaut.security.event.LoginSuccessfulEvent;
import io.micronaut.security.handlers.RedirectingLoginHandler;
import io.micronaut.security.oauth2.client.OauthClient;
import io.micronaut.security.oauth2.routes.OauthController;
import jakarta.inject.Inject;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Requires(beans={RedirectingLoginHandler.class})
@EachBean(value=OauthClient.class)
public class DefaultOauthController
implements OauthController {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOauthController.class);
    private final OauthClient oauthClient;
    private final RedirectingLoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler;
    private final ApplicationEventPublisher<LoginSuccessfulEvent> loginSuccessfulEventPublisher;
    private final ApplicationEventPublisher<LoginFailedEvent> loginFailedEventPublisher;
    private final HttpHostResolver httpHostResolver;
    private final HttpLocaleResolver httpLocaleResolver;

    @Inject
    DefaultOauthController(@Parameter OauthClient oauthClient, RedirectingLoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler, ApplicationEventPublisher<LoginSuccessfulEvent> loginSuccessfulEventPublisher, ApplicationEventPublisher<LoginFailedEvent> loginFailedEventPublisher, HttpHostResolver httpHostResolver, HttpLocaleResolver httpLocaleResolver) {
        this.oauthClient = oauthClient;
        this.loginHandler = loginHandler;
        this.loginSuccessfulEventPublisher = loginSuccessfulEventPublisher;
        this.loginFailedEventPublisher = loginFailedEventPublisher;
        this.httpHostResolver = httpHostResolver;
        this.httpLocaleResolver = httpLocaleResolver;
    }

    @Deprecated(forRemoval=true, since="4.7.0")
    DefaultOauthController(@Parameter OauthClient oauthClient, RedirectingLoginHandler<HttpRequest<?>, MutableHttpResponse<?>> loginHandler, ApplicationEventPublisher<LoginSuccessfulEvent> loginSuccessfulEventPublisher, ApplicationEventPublisher<LoginFailedEvent> loginFailedEventPublisher) {
        this(oauthClient, loginHandler, loginSuccessfulEventPublisher, loginFailedEventPublisher, request -> null, new HttpLocaleResolver(){

            @NonNull
            public Optional<Locale> resolve(@NonNull HttpRequest<?> context) {
                return Optional.of(this.resolveOrDefault(context));
            }

            @NonNull
            public Locale resolveOrDefault(@NonNull HttpRequest<?> context) {
                return Locale.getDefault();
            }
        });
    }

    @Override
    public OauthClient getClient() {
        return this.oauthClient;
    }

    @Override
    public Publisher<MutableHttpResponse<?>> login(HttpRequest<?> request) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received login request for provider [{}]", (Object)this.oauthClient.getName());
        }
        return this.oauthClient.authorizationRedirect(request);
    }

    @Override
    public Publisher<MutableHttpResponse<?>> callback(HttpRequest<Map<String, Object>> request) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received callback from oauth provider [{}]", (Object)this.oauthClient.getName());
        }
        Publisher<AuthenticationResponse> authenticationResponse = this.oauthClient.onCallback(request);
        return Flux.from(authenticationResponse).map(response -> {
            if (response.isAuthenticated() && response.getAuthentication().isPresent()) {
                Authentication authentication = (Authentication)response.getAuthentication().get();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Authentication succeeded. User [{}] is now logged in", (Object)authentication.getName());
                }
                this.loginSuccessfulEventPublisher.publishEvent((Object)new LoginSuccessfulEvent((Object)authentication, this.httpHostResolver.resolve(request), this.httpLocaleResolver.resolveOrDefault((Object)request)));
                return (MutableHttpResponse)this.loginHandler.loginSuccess(authentication, (Object)request);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Authentication failed: {}", (Object)response.getMessage().orElse("unknown reason"));
            }
            this.loginFailedEventPublisher.publishEvent((Object)new LoginFailedEvent(response, null, this.httpHostResolver.resolve(request), this.httpLocaleResolver.resolveOrDefault((Object)request)));
            return (MutableHttpResponse)this.loginHandler.loginFailed(response, (Object)request);
        }).defaultIfEmpty((Object)HttpResponse.status((HttpStatus)HttpStatus.UNAUTHORIZED));
    }
}

