/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationMode;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RedirectService;
import io.micronaut.security.errors.ErrorCode;
import io.micronaut.security.errors.OauthErrorResponseException;
import io.micronaut.security.errors.ObtainingAuthorizationErrorCode;
import io.micronaut.security.errors.PriorToLoginPersistence;
import io.micronaut.security.token.jwt.cookie.AccessTokenCookieConfiguration;
import io.micronaut.security.token.jwt.cookie.CookieLoginHandler;
import jakarta.inject.Singleton;
import java.text.ParseException;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(property="micronaut.security.authentication", value="idtoken")
@Singleton
public class IdTokenLoginHandler
extends CookieLoginHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IdTokenLoginHandler.class);

    public IdTokenLoginHandler(AccessTokenCookieConfiguration accessTokenCookieConfiguration, RedirectConfiguration redirectConfiguration, RedirectService redirectService, @Nullable PriorToLoginPersistence priorToLoginPersistence) {
        super(accessTokenCookieConfiguration, redirectConfiguration, redirectService, priorToLoginPersistence);
    }

    public List<Cookie> getCookies(Authentication authentication, HttpRequest<?> request) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(1);
        String accessToken = this.parseIdToken(authentication).orElseThrow(() -> new OauthErrorResponseException((ErrorCode)ObtainingAuthorizationErrorCode.SERVER_ERROR, "Cannot obtain an access token", null));
        Cookie jwtCookie = Cookie.of((String)this.accessTokenCookieConfiguration.getCookieName(), (String)accessToken);
        jwtCookie.configure((CookieConfiguration)this.accessTokenCookieConfiguration, request.isSecure());
        jwtCookie.maxAge((TemporalAmount)this.cookieExpiration(authentication, request));
        cookies.add(jwtCookie);
        return cookies;
    }

    public List<Cookie> getCookies(Authentication authentication, String refreshToken, HttpRequest<?> request) {
        throw new OauthErrorResponseException((ErrorCode)ObtainingAuthorizationErrorCode.INVALID_REQUEST, "Cannot refresh a provider token through the oauth endpoint. The token must be refreshed directly with the provider", null);
    }

    protected Optional<String> parseIdToken(Authentication authentication) {
        Map attributes = authentication.getAttributes();
        if (!attributes.containsKey("openIdToken")) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("{} should be present in user details attributes to use {}:{}", new Object[]{"openIdToken", "micronaut.security.authentication", AuthenticationMode.IDTOKEN});
            }
            return Optional.empty();
        }
        Object idTokenObjet = attributes.get("openIdToken");
        if (!(idTokenObjet instanceof String)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("{} present in user details attributes should be of type String to use {}:{}", new Object[]{"openIdToken", "micronaut.security.authentication", AuthenticationMode.IDTOKEN});
            }
            return Optional.empty();
        }
        return Optional.of((String)idTokenObjet);
    }

    protected Duration cookieExpiration(Authentication authentication, HttpRequest<?> request) {
        Optional<String> idTokenOptional = this.parseIdToken(authentication);
        if (!idTokenOptional.isPresent()) {
            return Duration.ofSeconds(0L);
        }
        String idToken = idTokenOptional.get();
        try {
            JWT jwt = JWTParser.parse((String)idToken);
            Date exp = jwt.getJWTClaimsSet().getExpirationTime();
            if (exp == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("unable to define a cookie expiration because id token exp claim is not set");
                }
                return Duration.ofSeconds(0L);
            }
            return Duration.between(new Date().toInstant(), exp.toInstant());
        }
        catch (ParseException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("unable to define a cookie expiration because id token cannot be parsed to JWT");
            }
            return Duration.ofSeconds(0L);
        }
    }
}

