/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parallel;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.security.oauth2.client.DefaultOpenIdClient;
import io.micronaut.security.oauth2.client.DefaultOpenIdProviderMetadata;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadataFetcher;
import io.micronaut.security.oauth2.client.condition.OpenIdClientCondition;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.AuthorizationEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndSessionEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.OauthAuthorizationEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.SecureEndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRedirectHandler;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponseHandler;
import io.micronaut.security.oauth2.endpoint.endsession.request.EndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.EndSessionEndpointResolver;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdAuthenticationMapper;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;

@Factory
@Internal
@Requires(configuration="io.micronaut.security.token.jwt")
class OpenIdClientFactory {
    private final BeanContext beanContext;

    OpenIdClientFactory(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Parallel
    @Context
    @EachBean(value=OpenIdClientConfiguration.class)
    DefaultOpenIdProviderMetadata openIdConfiguration(@Parameter OauthClientConfiguration oauthClientConfiguration, @Parameter OpenIdClientConfiguration openIdClientConfiguration, @Parameter OpenIdProviderMetadataFetcher openIdProviderMetadataFetcher) {
        DefaultOpenIdProviderMetadata providerMetadata = openIdProviderMetadataFetcher.fetch();
        OpenIdClientFactory.overrideFromConfig(providerMetadata, openIdClientConfiguration, oauthClientConfiguration);
        return providerMetadata;
    }

    @EachBean(value=OpenIdClientConfiguration.class)
    @Requires(condition=OpenIdClientCondition.class)
    DefaultOpenIdClient openIdClient(@Parameter OpenIdClientConfiguration openIdClientConfiguration, @Parameter OauthClientConfiguration clientConfiguration, @Parameter BeanProvider<DefaultOpenIdProviderMetadata> openIdProviderMetadata, @Parameter @Nullable OpenIdAuthenticationMapper authenticationMapper, AuthorizationRedirectHandler redirectUrlBuilder, OpenIdAuthorizationResponseHandler authorizationResponseHandler, EndSessionEndpointResolver endSessionEndpointResolver, EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder) {
        Supplier metadataSupplier = SupplierUtil.memoized(() -> openIdProviderMetadata.get());
        EndSessionEndpoint endSessionEndpoint = null;
        if (openIdClientConfiguration.getEndSession().isEnabled()) {
            endSessionEndpoint = endSessionEndpointResolver.resolve(clientConfiguration, metadataSupplier, endSessionCallbackUrlBuilder).orElse(null);
        }
        return new DefaultOpenIdClient(clientConfiguration, metadataSupplier, authenticationMapper, redirectUrlBuilder, authorizationResponseHandler, this.beanContext, endSessionEndpoint);
    }

    @NonNull
    private static DefaultOpenIdProviderMetadata overrideFromConfig(@Nullable DefaultOpenIdProviderMetadata providerMetadata, @NonNull OpenIdClientConfiguration openIdClientConfiguration, @NonNull OauthClientConfiguration oauthClientConfiguration) {
        String endSessionEndpoint = providerMetadata == null ? null : providerMetadata.getEndSessionEndpoint();
        EndSessionEndpointConfiguration endSession = openIdClientConfiguration.getEndSession();
        Optional<AuthorizationEndpointConfiguration> authorization = openIdClientConfiguration.getAuthorization();
        return new DefaultOpenIdProviderMetadata(authorization.flatMap(EndpointConfiguration::getUrl).orElseGet(() -> providerMetadata == null ? null : providerMetadata.getAuthorizationEndpoint()), providerMetadata == null ? null : providerMetadata.getIdTokenSigningAlgValuesSupported(), providerMetadata == null ? null : providerMetadata.getIssuer(), openIdClientConfiguration.getJwksUri().orElseGet(() -> providerMetadata == null ? null : providerMetadata.getJwksUri()), providerMetadata == null ? null : providerMetadata.getAcrValuesSupported(), providerMetadata == null ? null : providerMetadata.getResponseTypesSupported(), providerMetadata == null ? null : providerMetadata.getResponseModesSupported(), providerMetadata == null ? null : providerMetadata.getScopesSupported(), providerMetadata == null ? null : providerMetadata.getGrantTypesSupported(), providerMetadata == null ? null : providerMetadata.getSubjectTypesSupported(), openIdClientConfiguration.getToken().flatMap(EndpointConfiguration::getUrl).orElseGet(() -> providerMetadata == null ? null : providerMetadata.getTokenEndpoint()), oauthClientConfiguration.getToken().flatMap(SecureEndpointConfiguration::getAuthMethod).map(authMethod -> Collections.singletonList(authMethod.toString())).orElseGet(() -> providerMetadata == null ? null : providerMetadata.getTokenEndpointAuthMethodsSupported()), openIdClientConfiguration.getUserInfo().flatMap(EndpointConfiguration::getUrl).orElseGet(() -> providerMetadata == null ? null : providerMetadata.getUserinfoEndpoint()), openIdClientConfiguration.getRegistration().flatMap(EndpointConfiguration::getUrl).orElseGet(() -> providerMetadata == null ? null : providerMetadata.getRegistrationEndpoint()), providerMetadata == null ? null : providerMetadata.getClaimsSupported(), authorization.flatMap(OauthAuthorizationEndpointConfiguration::getCodeChallengeMethod).map(Collections::singletonList).orElseGet(() -> providerMetadata == null ? null : providerMetadata.getCodeChallengeMethodsSupported()), oauthClientConfiguration.getIntrospection().flatMap(EndpointConfiguration::getUrl).orElseGet(() -> providerMetadata == null ? null : providerMetadata.getIntrospectionEndpoint()), oauthClientConfiguration.getIntrospection().flatMap(SecureEndpointConfiguration::getAuthMethod).map(authMethod -> Collections.singletonList(authMethod.toString())).orElseGet(() -> providerMetadata == null ? null : providerMetadata.getIntrospectionEndpointAuthMethodsSupported()), oauthClientConfiguration.getRevocation().flatMap(EndpointConfiguration::getUrl).orElseGet(() -> providerMetadata == null ? null : providerMetadata.getRevocationEndpoint()), oauthClientConfiguration.getRevocation().flatMap(SecureEndpointConfiguration::getAuthMethod).map(authMethod -> Collections.singletonList(authMethod.toString())).orElseGet(() -> providerMetadata == null ? null : providerMetadata.getRevocationEndpointAuthMethodsSupported()), endSession.isEnabled() ? endSession.getUrl().orElse(endSessionEndpoint) : endSessionEndpoint, providerMetadata == null ? null : providerMetadata.getRequestParameterSupported(), providerMetadata == null ? null : providerMetadata.getRequestUriParameterSupported(), providerMetadata == null ? null : providerMetadata.getRequireRequestUriRegistration(), providerMetadata == null ? null : providerMetadata.getRequestObjectSigningAlgValuesSupported(), providerMetadata == null ? null : providerMetadata.getServiceDocumentation(), providerMetadata == null ? null : providerMetadata.getIdTokenEncryptionEncValuesSupported(), providerMetadata == null ? null : providerMetadata.getDisplayValuesSupported(), providerMetadata == null ? null : providerMetadata.getClaimTypesSupported(), providerMetadata == null ? null : providerMetadata.getClaimsParameterSupported(), providerMetadata == null ? null : providerMetadata.getOpTosUri(), providerMetadata == null ? null : providerMetadata.getOpPolicyUri(), providerMetadata == null ? null : providerMetadata.getUriLocalesSupported(), providerMetadata == null ? null : providerMetadata.getClaimsLocalesSupported(), providerMetadata == null ? null : providerMetadata.getUserInfoEncryptionAlgValuesSupported(), providerMetadata == null ? null : providerMetadata.getUserinfoEncryptionEncValuesSupported(), providerMetadata == null ? null : providerMetadata.getTokenEndpointAuthSigningAlgValuesSupported(), providerMetadata == null ? null : providerMetadata.getRequestObjectEncryptionAlgValuesSupported(), providerMetadata == null ? null : providerMetadata.getRequestObjectEncryptionEncValuesSupported(), providerMetadata == null ? null : providerMetadata.getCheckSessionIframe());
    }
}

