/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.serde.annotation.Serdeable;
import java.util.Arrays;
import java.util.List;

@ReflectiveAccess
@Serdeable
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class DefaultOpenIdProviderMetadata
implements OpenIdProviderMetadata {
    @NonNull
    private final String authorizationEndpoint;
    @NonNull
    private final List<String> idTokenSigningAlgValuesSupported;
    @NonNull
    private final String issuer;
    @NonNull
    private final String jwksUri;
    @Nullable
    private final List<String> acrValuesSupported;
    @Nullable
    private final List<String> responseTypesSupported;
    @Nullable
    private final List<String> responseModesSupported;
    @Nullable
    private final List<String> scopesSupported;
    @Nullable
    private final List<String> grantTypesSupported;
    @NonNull
    private final List<String> subjectTypesSupported;
    @NonNull
    private final String tokenEndpoint;
    @Nullable
    private final List<String> tokenEndpointAuthMethodsSupported;
    @Nullable
    private final String userinfoEndpoint;
    @Nullable
    private final String registrationEndpoint;
    @Nullable
    private final List<String> claimsSupported;
    @Nullable
    private final List<String> codeChallengeMethodsSupported;
    @Nullable
    private final String introspectionEndpoint;
    @Nullable
    private final List<String> introspectionEndpointAuthMethodsSupported;
    @Nullable
    private final String revocationEndpoint;
    @Nullable
    private final List<String> revocationEndpointAuthMethodsSupported;
    @Nullable
    private final String endSessionEndpoint;
    @Nullable
    private final Boolean requestParameterSupported;
    @Nullable
    private final Boolean requestUriParameterSupported;
    @Nullable
    private final Boolean requireRequestUriRegistration;
    @Nullable
    private final List<String> requestObjectSigningAlgValuesSupported;
    @Nullable
    private final String serviceDocumentation;
    @Nullable
    private final List<String> idTokenEncryptionEncValuesSupported;
    @Nullable
    private final List<String> displayValuesSupported;
    @Nullable
    private final List<String> claimTypesSupported;
    @Nullable
    private final Boolean claimsParameterSupported;
    @Nullable
    private final String opTosUri;
    @Nullable
    private final String opPolicyUri;
    @Nullable
    private final List<String> uriLocalesSupported;
    @Nullable
    private final List<String> claimsLocalesSupported;
    @Nullable
    private final List<String> userinfoEncryptionAlgValuesSupported;
    @Nullable
    private final List<String> userinfoEncryptionEncValuesSupported;
    @Nullable
    private final List<String> tokenEndpointAuthSigningAlgValuesSupported;
    @Nullable
    private final List<String> requestObjectEncryptionAlgValuesSupported;
    @Nullable
    private final List<String> requestObjectEncryptionEncValuesSupported;
    @Nullable
    private final String checkSessionIframe;

    public DefaultOpenIdProviderMetadata(@Nullable String authorizationEndpoint, @NonNull List<String> idTokenSigningAlgValuesSupported, @NonNull String issuer, @NonNull String jwksUri, @Nullable List<String> acrValuesSupported, @Nullable List<String> responseTypesSupported, @Nullable List<String> responseModesSupported, @Nullable List<String> scopesSupported, @Nullable List<String> grantTypesSupported, @NonNull List<String> subjectTypesSupported, @NonNull String tokenEndpoint, @Nullable List<String> tokenEndpointAuthMethodsSupported, @Nullable String userinfoEndpoint, @Nullable String registrationEndpoint, @Nullable List<String> claimsSupported, @Nullable List<String> codeChallengeMethodsSupported, @Nullable String introspectionEndpoint, @Nullable List<String> introspectionEndpointAuthMethodsSupported, @Nullable String revocationEndpoint, @Nullable List<String> revocationEndpointAuthMethodsSupported, @Nullable String endSessionEndpoint, @Nullable Boolean requestParameterSupported, @Nullable Boolean requestUriParameterSupported, @Nullable Boolean requireRequestUriRegistration, @Nullable List<String> requestObjectSigningAlgValuesSupported, @Nullable String serviceDocumentation, @Nullable List<String> idTokenEncryptionEncValuesSupported, @Nullable List<String> displayValuesSupported, @Nullable List<String> claimTypesSupported, @Nullable Boolean claimsParameterSupported, @Nullable String opTosUri, @Nullable String opPolicyUri, @Nullable List<String> uriLocalesSupported, @Nullable List<String> claimsLocalesSupported, @Nullable List<String> userinfoEncryptionAlgValuesSupported, @Nullable List<String> userinfoEncryptionEncValuesSupported, @Nullable List<String> tokenEndpointAuthSigningAlgValuesSupported, @Nullable List<String> requestObjectEncryptionAlgValuesSupported, @Nullable List<String> requestObjectEncryptionEncValuesSupported, @Nullable String checkSessionIframe) {
        this.authorizationEndpoint = authorizationEndpoint;
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
        this.issuer = issuer;
        this.jwksUri = jwksUri;
        this.acrValuesSupported = acrValuesSupported;
        this.responseTypesSupported = responseTypesSupported;
        this.responseModesSupported = responseModesSupported;
        this.scopesSupported = scopesSupported;
        this.grantTypesSupported = grantTypesSupported;
        this.subjectTypesSupported = subjectTypesSupported;
        this.tokenEndpoint = tokenEndpoint;
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
        this.userinfoEndpoint = userinfoEndpoint;
        this.registrationEndpoint = registrationEndpoint;
        this.claimsSupported = claimsSupported;
        this.codeChallengeMethodsSupported = codeChallengeMethodsSupported;
        this.introspectionEndpoint = introspectionEndpoint;
        this.introspectionEndpointAuthMethodsSupported = introspectionEndpointAuthMethodsSupported;
        this.revocationEndpoint = revocationEndpoint;
        this.revocationEndpointAuthMethodsSupported = revocationEndpointAuthMethodsSupported;
        this.endSessionEndpoint = endSessionEndpoint;
        this.requestParameterSupported = requestParameterSupported;
        this.requestUriParameterSupported = requestUriParameterSupported;
        this.requireRequestUriRegistration = requireRequestUriRegistration;
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
        this.serviceDocumentation = serviceDocumentation;
        this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
        this.displayValuesSupported = displayValuesSupported;
        this.claimTypesSupported = claimTypesSupported;
        this.claimsParameterSupported = claimsParameterSupported != null ? claimsParameterSupported : Boolean.FALSE;
        this.opTosUri = opTosUri;
        this.opPolicyUri = opPolicyUri;
        this.uriLocalesSupported = uriLocalesSupported;
        this.claimsLocalesSupported = claimsLocalesSupported;
        this.userinfoEncryptionAlgValuesSupported = userinfoEncryptionAlgValuesSupported;
        this.userinfoEncryptionEncValuesSupported = userinfoEncryptionEncValuesSupported;
        this.tokenEndpointAuthSigningAlgValuesSupported = tokenEndpointAuthSigningAlgValuesSupported;
        this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
        this.requestObjectEncryptionEncValuesSupported = requestObjectEncryptionEncValuesSupported;
        this.checkSessionIframe = checkSessionIframe;
    }

    @Override
    @Nullable
    public Boolean getRequireRequestUriRegistration() {
        return this.requireRequestUriRegistration;
    }

    @Nullable
    public Boolean getDefaultRequireRequestUriRegistration() {
        return Boolean.FALSE;
    }

    @Override
    @Nullable
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    @Override
    @NonNull
    public List<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getIdTokenEncryptionEncValuesSupported() {
        return this.idTokenEncryptionEncValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getUserInfoEncryptionAlgValuesSupported() {
        return this.userinfoEncryptionAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getUserinfoEncryptionEncValuesSupported() {
        return this.userinfoEncryptionEncValuesSupported;
    }

    @Override
    @NonNull
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    @NonNull
    public String getJwksUri() {
        return this.jwksUri;
    }

    @Override
    @Nullable
    public List<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    @NonNull
    public List<String> getDefaultResponseTypesSupported() {
        return Arrays.asList("query", "fragment");
    }

    @Override
    @Nullable
    public List<String> getScopesSupported() {
        return this.scopesSupported;
    }

    @Override
    @NonNull
    public List<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    @Override
    @NonNull
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @Override
    @Nullable
    public List<String> getTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    @Override
    @Nullable
    public List<String> getTokenEndpointAuthSigningAlgValuesSupported() {
        return this.tokenEndpointAuthSigningAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getDisplayValuesSupported() {
        return this.displayValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getClaimTypesSupported() {
        return this.claimTypesSupported;
    }

    @Override
    @Nullable
    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    @Override
    @Nullable
    public List<String> getResponseModesSupported() {
        return this.responseModesSupported;
    }

    @Override
    @Nullable
    public List<String> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    @NonNull
    public List<String> getDefaultGrantTypesSupported() {
        return Arrays.asList("authorization_code", "implicit");
    }

    @Override
    @Nullable
    public List<String> getAcrValuesSupported() {
        return this.acrValuesSupported;
    }

    @Override
    @Nullable
    public String getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    @Override
    @Nullable
    public List<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    @Override
    @Nullable
    public String getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    @Override
    @Nullable
    public List<String> getClaimsLocalesSupported() {
        return this.claimsLocalesSupported;
    }

    @Override
    @Nullable
    public List<String> getUriLocalesSupported() {
        return this.uriLocalesSupported;
    }

    @Override
    @Nullable
    public Boolean getClaimsParameterSupported() {
        return this.claimsParameterSupported;
    }

    @Override
    @Nullable
    public List<String> getCodeChallengeMethodsSupported() {
        return this.codeChallengeMethodsSupported;
    }

    @Override
    @Nullable
    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    @Override
    @Nullable
    public List<String> getIntrospectionEndpointAuthMethodsSupported() {
        return this.introspectionEndpointAuthMethodsSupported;
    }

    @Override
    @Nullable
    public String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    @Override
    @Nullable
    public List<String> getRevocationEndpointAuthMethodsSupported() {
        return this.revocationEndpointAuthMethodsSupported;
    }

    @Override
    @Nullable
    public String getCheckSessionIframe() {
        return this.checkSessionIframe;
    }

    @Override
    @Nullable
    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    @Override
    @Nullable
    public Boolean getRequestParameterSupported() {
        return this.requestParameterSupported;
    }

    @NonNull
    public Boolean getDefaultRequestParameterSupported() {
        return Boolean.FALSE;
    }

    @Override
    @Nullable
    public Boolean getRequestUriParameterSupported() {
        return this.requestUriParameterSupported;
    }

    @NonNull
    public Boolean getDefaultRequestUriParameterSupported() {
        return Boolean.TRUE;
    }

    @Override
    @Nullable
    public String getOpPolicyUri() {
        return this.opPolicyUri;
    }

    @Override
    @Nullable
    public String getOpTosUri() {
        return this.opTosUri;
    }

    @Override
    @Nullable
    public List<String> getRequestObjectSigningAlgValuesSupported() {
        return this.requestObjectSigningAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getRequestObjectEncryptionAlgValuesSupported() {
        return this.requestObjectEncryptionAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getRequestObjectEncryptionEncValuesSupported() {
        return this.requestObjectEncryptionEncValuesSupported;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String authorizationEndpoint;
        @NonNull
        private List<String> idTokenSigningAlgValuesSupported;
        @NonNull
        private String issuer;
        @NonNull
        private String jwksUri;
        @Nullable
        private List<String> acrValuesSupported;
        @Nullable
        private List<String> responseTypesSupported;
        @Nullable
        private List<String> responseModesSupported;
        @Nullable
        private List<String> scopesSupported;
        @Nullable
        private List<String> grantTypesSupported;
        @NonNull
        private List<String> subjectTypesSupported;
        @NonNull
        private String tokenEndpoint;
        @Nullable
        private List<String> tokenEndpointAuthMethodsSupported;
        @Nullable
        private String userinfoEndpoint;
        @Nullable
        private String registrationEndpoint;
        @Nullable
        private List<String> claimsSupported;
        @Nullable
        private List<String> codeChallengeMethodsSupported;
        @Nullable
        private String introspectionEndpoint;
        @Nullable
        private List<String> introspectionEndpointAuthMethodsSupported;
        @Nullable
        private String revocationEndpoint;
        @Nullable
        private List<String> revocationEndpointAuthMethodsSupported;
        @Nullable
        private String endSessionEndpoint;
        @Nullable
        private Boolean requestParameterSupported;
        @Nullable
        private Boolean requestUriParameterSupported;
        @Nullable
        private Boolean requireRequestUriRegistration;
        @Nullable
        private List<String> requestObjectSigningAlgValuesSupported;
        @Nullable
        private String serviceDocumentation;
        @Nullable
        private List<String> idTokenEncryptionEncValuesSupported;
        @Nullable
        private List<String> displayValuesSupported;
        @Nullable
        private List<String> claimTypesSupported;
        @NonNull
        private Boolean claimsParameterSupported = Boolean.FALSE;
        @Nullable
        private String opTosUri;
        @Nullable
        private String opPolicyUri;
        @Nullable
        private List<String> uriLocalesSupported;
        @Nullable
        private List<String> claimsLocalesSupported;
        @Nullable
        private List<String> userinfoEncryptionAlgValuesSupported;
        @Nullable
        private List<String> userinfoEncryptionEncValuesSupported;
        @Nullable
        private List<String> tokenEndpointAuthSigningAlgValuesSupported;
        @Nullable
        private List<String> requestObjectEncryptionAlgValuesSupported;
        @Nullable
        private List<String> requestObjectEncryptionEncValuesSupported;
        @Nullable
        private String checkSessionIframe;

        @NonNull
        public Builder authorizationEndpoint(@Nullable String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        @NonNull
        public Builder idTokenSigningAlgValuesSupported(@NonNull List<String> idTokenSigningAlgValuesSupported) {
            this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder issuer(@NonNull String issuer) {
            this.issuer = issuer;
            return this;
        }

        @NonNull
        public Builder jwksUri(@NonNull String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        @NonNull
        public Builder acrValuesSupported(@NonNull List<String> acrValuesSupported) {
            this.acrValuesSupported = acrValuesSupported;
            return this;
        }

        @NonNull
        public Builder responseTypesSupported(@Nullable List<String> responseTypesSupported) {
            this.responseTypesSupported = responseTypesSupported;
            return this;
        }

        @NonNull
        public Builder responseModesSupported(@Nullable List<String> responseModesSupported) {
            this.responseModesSupported = responseModesSupported;
            return this;
        }

        @NonNull
        public Builder scopesSupported(@Nullable List<String> scopesSupported) {
            this.scopesSupported = scopesSupported;
            return this;
        }

        @NonNull
        public Builder grantTypesSupported(@Nullable List<String> grantTypesSupported) {
            this.grantTypesSupported = grantTypesSupported;
            return this;
        }

        @NonNull
        public Builder subjectTypesSupported(@NonNull List<String> subjectTypesSupported) {
            this.subjectTypesSupported = subjectTypesSupported;
            return this;
        }

        @NonNull
        public Builder tokenEndpoint(@NonNull String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        @NonNull
        public Builder tokenEndpointAuthMethodsSupported(@Nullable List<String> tokenEndpointAuthMethodsSupported) {
            this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
            return this;
        }

        @NonNull
        public Builder userinfoEndpoint(@Nullable String userinfoEndpoint) {
            this.userinfoEndpoint = userinfoEndpoint;
            return this;
        }

        @NonNull
        public Builder registrationEndpoint(@Nullable String registrationEndpoint) {
            this.registrationEndpoint = registrationEndpoint;
            return this;
        }

        @NonNull
        public Builder claimsSupported(@Nullable List<String> claimsSupported) {
            this.claimsSupported = claimsSupported;
            return this;
        }

        @NonNull
        public Builder codeChallengeMethodsSupported(@Nullable List<String> codeChallengeMethodsSupported) {
            this.codeChallengeMethodsSupported = codeChallengeMethodsSupported;
            return this;
        }

        @NonNull
        public Builder introspectionEndpoint(@Nullable String introspectionEndpoint) {
            this.introspectionEndpoint = introspectionEndpoint;
            return this;
        }

        @NonNull
        public Builder introspectionEndpointAuthMethodsSupported(@Nullable List<String> introspectionEndpointAuthMethodsSupported) {
            this.introspectionEndpointAuthMethodsSupported = introspectionEndpointAuthMethodsSupported;
            return this;
        }

        @NonNull
        public Builder revocationEndpoint(@Nullable String revocationEndpoint) {
            this.revocationEndpoint = revocationEndpoint;
            return this;
        }

        @NonNull
        public Builder revocationEndpointAuthMethodsSupported(@Nullable List<String> revocationEndpointAuthMethodsSupported) {
            this.revocationEndpointAuthMethodsSupported = revocationEndpointAuthMethodsSupported;
            return this;
        }

        @NonNull
        public Builder endSessionEndpoint(@Nullable String endSessionEndpoint) {
            this.endSessionEndpoint = endSessionEndpoint;
            return this;
        }

        @NonNull
        public Builder requestParameterSupported(@Nullable Boolean requestParameterSupported) {
            this.requestParameterSupported = requestParameterSupported;
            return this;
        }

        @NonNull
        public Builder requestUriParameterSupported(@Nullable Boolean requestUriParameterSupported) {
            this.requestUriParameterSupported = requestUriParameterSupported;
            return this;
        }

        @NonNull
        public Builder requireRequestUriRegistration(@Nullable Boolean requireRequestUriRegistration) {
            this.requireRequestUriRegistration = requireRequestUriRegistration;
            return this;
        }

        @NonNull
        public Builder requestObjectSigningAlgValuesSupported(@Nullable List<String> requestObjectSigningAlgValuesSupported) {
            this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder serviceDocumentation(@Nullable String serviceDocumentation) {
            this.serviceDocumentation = serviceDocumentation;
            return this;
        }

        @NonNull
        public Builder idTokenEncryptionEncValuesSupported(@Nullable List<String> idTokenEncryptionEncValuesSupported) {
            this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
            return this;
        }

        @NonNull
        public Builder displayValuesSupported(@Nullable List<String> displayValuesSupported) {
            this.displayValuesSupported = displayValuesSupported;
            return this;
        }

        @NonNull
        public Builder claimTypesSupported(@Nullable List<String> claimTypesSupported) {
            this.claimTypesSupported = claimTypesSupported;
            return this;
        }

        @NonNull
        public Builder claimsParameterSupported(@NonNull Boolean claimsParameterSupported) {
            this.claimsParameterSupported = claimsParameterSupported;
            return this;
        }

        @NonNull
        public Builder opTosUri(@Nullable String opTosUri) {
            this.opTosUri = opTosUri;
            return this;
        }

        @NonNull
        public Builder opPolicyUri(@Nullable String opPolicyUri) {
            this.opPolicyUri = opPolicyUri;
            return this;
        }

        @NonNull
        public Builder uriLocalesSupported(@Nullable List<String> uriLocalesSupported) {
            this.uriLocalesSupported = uriLocalesSupported;
            return this;
        }

        @NonNull
        public Builder claimsLocalesSupported(@Nullable List<String> claimsLocalesSupported) {
            this.claimsLocalesSupported = claimsLocalesSupported;
            return this;
        }

        @NonNull
        public Builder userinfoEncryptionAlgValuesSupported(@Nullable List<String> userinfoEncryptionAlgValuesSupported) {
            this.userinfoEncryptionAlgValuesSupported = userinfoEncryptionAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder userinfoEncryptionEncValuesSupported(@Nullable List<String> userinfoEncryptionEncValuesSupported) {
            this.userinfoEncryptionEncValuesSupported = userinfoEncryptionEncValuesSupported;
            return this;
        }

        @NonNull
        public Builder tokenEndpointAuthSigningAlgValuesSupported(@Nullable List<String> tokenEndpointAuthSigningAlgValuesSupported) {
            this.tokenEndpointAuthSigningAlgValuesSupported = tokenEndpointAuthSigningAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder requestObjectEncryptionAlgValuesSupported(@Nullable List<String> requestObjectEncryptionAlgValuesSupported) {
            this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder requestObjectEncryptionEncValuesSupported(@Nullable List<String> requestObjectEncryptionEncValuesSupported) {
            this.requestObjectEncryptionEncValuesSupported = requestObjectEncryptionEncValuesSupported;
            return this;
        }

        @NonNull
        public Builder checkSessionIframe(@Nullable String checkSessionIframe) {
            this.checkSessionIframe = checkSessionIframe;
            return this;
        }

        @NonNull
        public DefaultOpenIdProviderMetadata build() {
            return new DefaultOpenIdProviderMetadata(this.authorizationEndpoint, this.idTokenSigningAlgValuesSupported, this.issuer, this.jwksUri, this.acrValuesSupported, this.responseTypesSupported, this.responseModesSupported, this.scopesSupported, this.grantTypesSupported, this.subjectTypesSupported, this.tokenEndpoint, this.tokenEndpointAuthMethodsSupported, this.userinfoEndpoint, this.registrationEndpoint, this.claimsSupported, this.codeChallengeMethodsSupported, this.introspectionEndpoint, this.introspectionEndpointAuthMethodsSupported, this.revocationEndpoint, this.revocationEndpointAuthMethodsSupported, this.endSessionEndpoint, this.requestParameterSupported, this.requestUriParameterSupported, this.requireRequestUriRegistration, this.requestObjectSigningAlgValuesSupported, this.serviceDocumentation, this.idTokenEncryptionEncValuesSupported, this.displayValuesSupported, this.claimTypesSupported, this.claimsParameterSupported, this.opTosUri, this.opPolicyUri, this.uriLocalesSupported, this.claimsLocalesSupported, this.userinfoEncryptionAlgValuesSupported, this.userinfoEncryptionEncValuesSupported, this.tokenEndpointAuthSigningAlgValuesSupported, this.requestObjectEncryptionAlgValuesSupported, this.requestObjectEncryptionEncValuesSupported, this.checkSessionIframe);
        }
    }
}

