/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.security.oauth2.client.DefaultOpenIdProviderMetadata;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsClient;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsEnabled;
import io.micronaut.security.oauth2.client.clientcredentials.DefaultClientCredentialsClient;
import io.micronaut.security.oauth2.client.clientcredentials.DefaultClientCredentialsOpenIdClient;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import java.util.function.Supplier;

@Factory
public class ClientCredentialsFactory {
    @EachBean(value=OauthClientConfiguration.class)
    @Requires(condition=ClientCredentialsEnabled.class)
    ClientCredentialsClient clientCredentialsOpenIdClient(@Parameter OauthClientConfiguration oauthClientConfiguration, TokenEndpointClient tokenEndpointClient, @Parameter @Nullable BeanProvider<DefaultOpenIdProviderMetadata> openIdProviderMetadata) {
        if (openIdProviderMetadata != null) {
            Supplier metadataSupplier = SupplierUtil.memoized(() -> openIdProviderMetadata.get());
            return new DefaultClientCredentialsOpenIdClient(oauthClientConfiguration, tokenEndpointClient, metadataSupplier);
        }
        if (oauthClientConfiguration.getToken().flatMap(EndpointConfiguration::getUrl).isPresent()) {
            return new DefaultClientCredentialsClient(oauthClientConfiguration, tokenEndpointClient);
        }
        throw new DisabledBeanException("Client credentials grant is disabled for OAuth 2.0 client [\"" + oauthClientConfiguration.getName() + "\"] because no token endpoint is configured");
    }
}

