/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.routes;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.event.LoginFailedEvent;
import io.micronaut.security.event.LoginSuccessfulEvent;
import io.micronaut.security.handlers.RedirectingLoginHandler;
import io.micronaut.security.oauth2.client.OauthClient;
import io.micronaut.security.oauth2.routes.OauthController;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Requires(beans={RedirectingLoginHandler.class})
@EachBean(value=OauthClient.class)
public class DefaultOauthController
implements OauthController {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOauthController.class);
    private final OauthClient oauthClient;
    private final RedirectingLoginHandler loginHandler;
    private final ApplicationEventPublisher eventPublisher;

    DefaultOauthController(@Parameter OauthClient oauthClient, RedirectingLoginHandler loginHandler, ApplicationEventPublisher eventPublisher) {
        this.oauthClient = oauthClient;
        this.loginHandler = loginHandler;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public OauthClient getClient() {
        return this.oauthClient;
    }

    @Override
    public Publisher<MutableHttpResponse<?>> login(HttpRequest<?> request) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received login request for provider [{}]", (Object)this.oauthClient.getName());
        }
        return this.oauthClient.authorizationRedirect(request);
    }

    @Override
    public Publisher<MutableHttpResponse<?>> callback(HttpRequest<Map<String, Object>> request) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received callback from oauth provider [{}]", (Object)this.oauthClient.getName());
        }
        Publisher<AuthenticationResponse> authenticationResponse = this.oauthClient.onCallback(request);
        return Flux.from(authenticationResponse).map(response -> {
            if (response.isAuthenticated() && response.getAuthentication().isPresent()) {
                Authentication authentication = (Authentication)response.getAuthentication().get();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Authentication succeeded. User [{}] is now logged in", (Object)authentication.getName());
                }
                this.eventPublisher.publishEvent((Object)new LoginSuccessfulEvent((Object)authentication));
                return this.loginHandler.loginSuccess(authentication, request);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Authentication failed: {}", (Object)response.getMessage().orElse("unknown reason"));
            }
            this.eventPublisher.publishEvent((Object)new LoginFailedEvent(response));
            return this.loginHandler.loginFailed(response, request);
        }).defaultIfEmpty((Object)HttpResponse.status((HttpStatus)HttpStatus.UNAUTHORIZED));
    }
}

