/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.response;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectiveAccess;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;

@ReflectiveAccess
@Introspected
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class TokenResponse {
    @NonNull
    private String accessToken;
    @NonNull
    private String tokenType;
    @Nullable
    private Integer expiresIn;
    @Nullable
    private String refreshToken;
    @Nullable
    private String scope;
    @Nullable
    private Date expiresInDate;

    public TokenResponse() {
    }

    public TokenResponse(@NonNull String accessToken, @NonNull String tokenType) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
    }

    @NonNull
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(@NonNull String accessToken) {
        this.accessToken = accessToken;
    }

    @NonNull
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(@NonNull String tokenType) {
        this.tokenType = tokenType;
    }

    @Nullable
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(@Nullable Integer expiresIn) {
        this.expiresIn = expiresIn;
        if (expiresIn != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, expiresIn);
            this.expiresInDate = calendar.getTime();
        }
    }

    @NonNull
    public Optional<Date> getExpiresInDate() {
        return Optional.ofNullable(this.expiresInDate);
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(@Nullable String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenResponse that = (TokenResponse)o;
        if (!this.accessToken.equals(that.accessToken)) {
            return false;
        }
        if (!this.tokenType.equals(that.tokenType)) {
            return false;
        }
        if (this.expiresIn != null ? !this.expiresIn.equals(that.expiresIn) : that.expiresIn != null) {
            return false;
        }
        if (this.refreshToken != null ? !this.refreshToken.equals(that.refreshToken) : that.refreshToken != null) {
            return false;
        }
        return this.scope != null ? this.scope.equals(that.scope) : that.scope == null;
    }

    public int hashCode() {
        int result = this.accessToken.hashCode();
        result = 31 * result + this.tokenType.hashCode();
        result = 31 * result + (this.expiresIn != null ? this.expiresIn.hashCode() : 0);
        result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }
}

