/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.state.persistence.cookie;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateSerDes;
import io.micronaut.security.oauth2.endpoint.authorization.state.persistence.StatePersistence;
import io.micronaut.security.oauth2.endpoint.authorization.state.persistence.cookie.CookieStatePersistenceConfiguration;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class CookieStatePersistence
implements StatePersistence {
    private final StateSerDes stateSerDes;
    private final CookieStatePersistenceConfiguration configuration;

    public CookieStatePersistence(StateSerDes stateSerDes, CookieStatePersistenceConfiguration configuration) {
        this.stateSerDes = stateSerDes;
        this.configuration = configuration;
    }

    @Override
    public Optional<State> retrieveState(HttpRequest<?> request) {
        Cookie cookie = request.getCookies().get((CharSequence)this.configuration.getCookieName());
        return Optional.ofNullable(cookie).map(c -> this.stateSerDes.deserialize(c.getValue()));
    }

    @Override
    public void persistState(HttpRequest<?> request, MutableHttpResponse response, State state) {
        String serializedState = this.stateSerDes.serialize(state);
        if (serializedState != null) {
            Cookie cookie = Cookie.of((String)this.configuration.getCookieName(), (String)serializedState);
            cookie.configure((CookieConfiguration)this.configuration, request.isSecure());
            response.cookie(cookie);
        }
    }
}

