/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@ReflectiveAccess
@Introspected
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class DefaultOpenIdProviderMetadata
implements OpenIdProviderMetadata {
    private String authorizationEndpoint;
    private List<String> idTokenSigningAlgValuesSupported;
    private String issuer;
    private String jwksUri;
    private List<String> acrValuesSupported;
    private List<String> responseTypesSupported;
    private List<String> responseModesSupported;
    private List<String> scopesSupported;
    private List<String> grantTypesSupported;
    private List<String> subjectTypesSupported;
    private String tokenEndpoint;
    private List<String> tokenEndpointAuthMethodsSupported;
    private String userinfoEndpoint;
    private String registrationEndpoint;
    private List<String> claimsSupported;
    private List<String> codeChallengeMethodsSupported;
    private String introspectionEndpoint;
    private List<String> introspectionEndpointAuthMethodsSupported;
    private String revocationEndpoint;
    private List<String> revocationEndpointAuthMethodsSupported;
    private String endSessionEndpoint;
    private Boolean requestParameterSupported;
    private Boolean requestUriParameterSupported;
    private Boolean requireRequestUriRegistration;
    private List<String> requestObjectSigningAlgValuesSupported;
    private String serviceDocumentation;
    private List<String> idTokenEncryptionEncValuesSupported;
    private List<String> displayValuesSupported;
    private List<String> claimTypesSupported;
    private Boolean claimsParameterSupported = Boolean.FALSE;
    private String opTosUri;
    private String opPolicyUri;
    private List<String> uriLocalesSupported;
    private List<String> claimsLocalesSupported;
    private List<String> userinfoEncryptionAlgValuesSupported;
    private List<String> userinfoEncryptionEncValuesSupported;
    private List<String> tokenEndpointAuthSigningAlgValuesSupported;
    private List<String> requestObjectEncryptionAlgValuesSupported;
    private List<String> requestObjectEncryptionEncValuesSupported;
    private String checkSessionIframe;

    @Override
    @Nullable
    public Boolean getRequireRequestUriRegistration() {
        return this.requireRequestUriRegistration;
    }

    @Nullable
    public Boolean getDefaultRequireRequestUriRegistration() {
        return Boolean.FALSE;
    }

    public void setRequireRequestUriRegistration(@Nullable Boolean requireRequestUriRegistration) {
        this.requireRequestUriRegistration = requireRequestUriRegistration;
    }

    @Override
    @NonNull
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(@NonNull String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public void setUserinfoEncryptionEncValuesSupported(@Nullable List<String> userinfoEncryptionEncValuesSupported) {
        this.userinfoEncryptionEncValuesSupported = userinfoEncryptionEncValuesSupported;
    }

    @Override
    @NonNull
    public List<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getIdTokenEncryptionEncValuesSupported() {
        return this.idTokenEncryptionEncValuesSupported;
    }

    public void setIdTokenEncryptionEncValuesSupported(@Nullable List<String> idTokenEncryptionEncValuesSupported) {
        this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getUserInfoEncryptionAlgValuesSupported() {
        return this.userinfoEncryptionAlgValuesSupported;
    }

    public void setUserinfoEncryptionAlgValuesSupported(@Nullable List<String> userinfoEncryptionAlgValuesSupported) {
        this.userinfoEncryptionAlgValuesSupported = userinfoEncryptionAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getUserinfoEncryptionEncValuesSupported() {
        return this.userinfoEncryptionEncValuesSupported;
    }

    public void setIdTokenSigningAlgValuesSupported(@NonNull List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }

    @Override
    @NonNull
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(@NonNull String issuer) {
        this.issuer = issuer;
    }

    @Override
    @NonNull
    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(@NonNull String jwksUri) {
        this.jwksUri = jwksUri;
    }

    @Override
    @Nullable
    public List<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    @NonNull
    public List<String> getDefaultResponseTypesSupported() {
        return Arrays.asList("query", "fragment");
    }

    public void setResponseTypesSupported(@Nullable List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    @Override
    @Nullable
    public List<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public void setScopesSupported(@Nullable List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    @Override
    @NonNull
    public List<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public void setSubjectTypesSupported(@NonNull List<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    @Override
    @NonNull
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(@Nullable String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    @Override
    @Nullable
    public List<String> getTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    @Override
    @Nullable
    public List<String> getTokenEndpointAuthSigningAlgValuesSupported() {
        return this.tokenEndpointAuthSigningAlgValuesSupported;
    }

    public void setTokenEndpointAuthSigningAlgValuesSupported(@Nullable List<String> tokenEndpointAuthSigningAlgValuesSupported) {
        this.tokenEndpointAuthSigningAlgValuesSupported = tokenEndpointAuthSigningAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getDisplayValuesSupported() {
        return this.displayValuesSupported;
    }

    public void setDisplayValuesSupported(@Nullable List<String> displayValuesSupported) {
        this.displayValuesSupported = displayValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getClaimTypesSupported() {
        return this.claimTypesSupported;
    }

    public void setClaimTypesSupported(@Nullable List<String> claimTypesSupported) {
        this.claimTypesSupported = claimTypesSupported;
    }

    public void setTokenEndpointAuthMethodsSupported(@Nullable List<String> tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
    }

    @Override
    @Nullable
    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public void setUserinfoEndpoint(@Nullable String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

    @Override
    @Nullable
    public List<String> getResponseModesSupported() {
        return this.responseModesSupported;
    }

    public void setResponseModesSupported(@Nullable List<String> responseModesSupported) {
        this.responseModesSupported = responseModesSupported;
    }

    @Override
    @Nullable
    public List<String> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    @NonNull
    public List<String> getDefaultGrantTypesSupported() {
        return Arrays.asList("authorization_code", "implicit");
    }

    @Override
    @Nullable
    public List<String> getAcrValuesSupported() {
        return this.acrValuesSupported;
    }

    public void setAcrValuesSupported(@Nullable List<String> acrValuesSupported) {
        this.acrValuesSupported = acrValuesSupported;
    }

    public void setGrantTypesSupported(@Nullable List<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    @Override
    @Nullable
    public String getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    public void setRegistrationEndpoint(@Nullable String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
    }

    @Override
    @Nullable
    public List<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    @Override
    @Nullable
    public String getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    public void setServiceDocumentation(@Nullable String serviceDocumentation) {
        this.serviceDocumentation = serviceDocumentation;
    }

    @Override
    @Nullable
    public List<String> getClaimsLocalesSupported() {
        return this.claimsLocalesSupported;
    }

    public void setClaimsLocalesSupported(@Nullable List<String> claimsLocalesSupported) {
        this.claimsLocalesSupported = claimsLocalesSupported;
    }

    @Override
    @Nullable
    public List<String> getUriLocalesSupported() {
        return this.uriLocalesSupported;
    }

    public void setUriLocalesSupported(@Nullable List<String> uriLocalesSupported) {
        this.uriLocalesSupported = uriLocalesSupported;
    }

    @Override
    @Nullable
    public Boolean getClaimsParameterSupported() {
        return this.claimsParameterSupported;
    }

    public void setClaimsParameterSupported(@Nullable Boolean claimsParameterSupported) {
        this.claimsParameterSupported = claimsParameterSupported;
    }

    public void setClaimsSupported(@Nullable List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    @Override
    @Nullable
    public List<String> getCodeChallengeMethodsSupported() {
        return this.codeChallengeMethodsSupported;
    }

    public void setCodeChallengeMethodsSupported(@Nullable List<String> codeChallengeMethodsSupported) {
        this.codeChallengeMethodsSupported = codeChallengeMethodsSupported;
    }

    @Override
    @Nullable
    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpoint(@Nullable String introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }

    @Override
    @Nullable
    public List<String> getIntrospectionEndpointAuthMethodsSupported() {
        return this.introspectionEndpointAuthMethodsSupported;
    }

    public void setIntrospectionEndpointAuthMethodsSupported(@Nullable List<String> introspectionEndpointAuthMethodsSupported) {
        this.introspectionEndpointAuthMethodsSupported = introspectionEndpointAuthMethodsSupported;
    }

    @Override
    @Nullable
    public String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    public void setRevocationEndpoint(@Nullable String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    @Override
    @Nullable
    public List<String> getRevocationEndpointAuthMethodsSupported() {
        return this.revocationEndpointAuthMethodsSupported;
    }

    public void setRevocationEndpointAuthMethodsSupported(@Nullable List<String> revocationEndpointAuthMethodsSupported) {
        this.revocationEndpointAuthMethodsSupported = revocationEndpointAuthMethodsSupported;
    }

    public void setCheckSessionIframe(@Nullable String checkSessionIframe) {
        this.checkSessionIframe = checkSessionIframe;
    }

    @Override
    @Nullable
    public String getCheckSessionIframe() {
        return this.checkSessionIframe;
    }

    @Override
    @Nullable
    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpoint(@Nullable String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    @Override
    @Nullable
    public Boolean getRequestParameterSupported() {
        return this.requestParameterSupported;
    }

    @NonNull
    public Boolean getDefaultRequestParameterSupported() {
        return Boolean.FALSE;
    }

    @Override
    @Nullable
    public Boolean getRequestUriParameterSupported() {
        return this.requestUriParameterSupported;
    }

    @NonNull
    public Boolean getDefaultRequestUriParameterSupported() {
        return Boolean.TRUE;
    }

    public void setRequestUriParameterSupported(@Nullable Boolean requestUriParameterSupported) {
        this.requestUriParameterSupported = requestUriParameterSupported;
    }

    @Override
    @Nullable
    public String getOpPolicyUri() {
        return this.opPolicyUri;
    }

    public void setOpPolicyUri(@Nullable String opPolicyUri) {
        this.opPolicyUri = opPolicyUri;
    }

    @Override
    @Nullable
    public String getOpTosUri() {
        return this.opTosUri;
    }

    public void setOpTosUri(@Nullable String opTosUri) {
        this.opTosUri = opTosUri;
    }

    public void setRequestParameterSupported(@Nullable Boolean requestParameterSupported) {
        this.requestParameterSupported = requestParameterSupported;
    }

    @Override
    @Nullable
    public List<String> getRequestObjectSigningAlgValuesSupported() {
        return this.requestObjectSigningAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getRequestObjectEncryptionAlgValuesSupported() {
        return this.requestObjectEncryptionAlgValuesSupported;
    }

    public void setRequestObjectEncryptionAlgValuesSupported(@Nullable List<String> requestObjectEncryptionAlgValuesSupported) {
        this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getRequestObjectEncryptionEncValuesSupported() {
        return this.requestObjectEncryptionEncValuesSupported;
    }

    public void setRequestObjectEncryptionEncValuesSupported(@Nullable List<String> requestObjectEncryptionEncValuesSupported) {
        this.requestObjectEncryptionEncValuesSupported = requestObjectEncryptionEncValuesSupported;
    }

    public void setRequestObjectSigningAlgValuesSupported(@Nullable List<String> requestObjectSigningAlgValuesSupported) {
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOpenIdProviderMetadata that = (DefaultOpenIdProviderMetadata)o;
        if (this.authorizationEndpoint != null ? !this.authorizationEndpoint.equals(that.authorizationEndpoint) : that.authorizationEndpoint != null) {
            return false;
        }
        if (this.idTokenSigningAlgValuesSupported != null ? !this.idTokenSigningAlgValuesSupported.equals(that.idTokenSigningAlgValuesSupported) : that.idTokenSigningAlgValuesSupported != null) {
            return false;
        }
        if (this.issuer != null ? !this.issuer.equals(that.issuer) : that.issuer != null) {
            return false;
        }
        if (this.jwksUri != null ? !this.jwksUri.equals(that.jwksUri) : that.jwksUri != null) {
            return false;
        }
        if (this.acrValuesSupported != null ? !this.acrValuesSupported.equals(that.acrValuesSupported) : that.acrValuesSupported != null) {
            return false;
        }
        if (this.responseTypesSupported != null ? !this.responseTypesSupported.equals(that.responseTypesSupported) : that.responseTypesSupported != null) {
            return false;
        }
        if (this.responseModesSupported != null ? !this.responseModesSupported.equals(that.responseModesSupported) : that.responseModesSupported != null) {
            return false;
        }
        if (this.scopesSupported != null ? !this.scopesSupported.equals(that.scopesSupported) : that.scopesSupported != null) {
            return false;
        }
        if (this.grantTypesSupported != null ? !this.grantTypesSupported.equals(that.grantTypesSupported) : that.grantTypesSupported != null) {
            return false;
        }
        if (this.subjectTypesSupported != null ? !this.subjectTypesSupported.equals(that.subjectTypesSupported) : that.subjectTypesSupported != null) {
            return false;
        }
        if (this.tokenEndpoint != null ? !this.tokenEndpoint.equals(that.tokenEndpoint) : that.tokenEndpoint != null) {
            return false;
        }
        if (this.tokenEndpointAuthMethodsSupported != null ? !this.tokenEndpointAuthMethodsSupported.equals(that.tokenEndpointAuthMethodsSupported) : that.tokenEndpointAuthMethodsSupported != null) {
            return false;
        }
        if (this.userinfoEndpoint != null ? !this.userinfoEndpoint.equals(that.userinfoEndpoint) : that.userinfoEndpoint != null) {
            return false;
        }
        if (this.registrationEndpoint != null ? !this.registrationEndpoint.equals(that.registrationEndpoint) : that.registrationEndpoint != null) {
            return false;
        }
        if (this.claimsSupported != null ? !this.claimsSupported.equals(that.claimsSupported) : that.claimsSupported != null) {
            return false;
        }
        if (this.codeChallengeMethodsSupported != null ? !this.codeChallengeMethodsSupported.equals(that.codeChallengeMethodsSupported) : that.codeChallengeMethodsSupported != null) {
            return false;
        }
        if (this.introspectionEndpoint != null ? !this.introspectionEndpoint.equals(that.introspectionEndpoint) : that.introspectionEndpoint != null) {
            return false;
        }
        if (this.introspectionEndpointAuthMethodsSupported != null ? !this.introspectionEndpointAuthMethodsSupported.equals(that.introspectionEndpointAuthMethodsSupported) : that.introspectionEndpointAuthMethodsSupported != null) {
            return false;
        }
        if (this.revocationEndpoint != null ? !this.revocationEndpoint.equals(that.revocationEndpoint) : that.revocationEndpoint != null) {
            return false;
        }
        if (this.revocationEndpointAuthMethodsSupported != null ? !this.revocationEndpointAuthMethodsSupported.equals(that.revocationEndpointAuthMethodsSupported) : that.revocationEndpointAuthMethodsSupported != null) {
            return false;
        }
        if (this.endSessionEndpoint != null ? !this.endSessionEndpoint.equals(that.endSessionEndpoint) : that.endSessionEndpoint != null) {
            return false;
        }
        if (this.requestParameterSupported != null ? !this.requestParameterSupported.equals(that.requestParameterSupported) : that.requestParameterSupported != null) {
            return false;
        }
        if (this.requestUriParameterSupported != null ? !this.requestUriParameterSupported.equals(that.requestUriParameterSupported) : that.requestUriParameterSupported != null) {
            return false;
        }
        if (this.requireRequestUriRegistration != null ? !this.requireRequestUriRegistration.equals(that.requireRequestUriRegistration) : that.requireRequestUriRegistration != null) {
            return false;
        }
        if (this.requestObjectSigningAlgValuesSupported != null ? !this.requestObjectSigningAlgValuesSupported.equals(that.requestObjectSigningAlgValuesSupported) : that.requestObjectSigningAlgValuesSupported != null) {
            return false;
        }
        if (this.serviceDocumentation != null ? !this.serviceDocumentation.equals(that.serviceDocumentation) : that.serviceDocumentation != null) {
            return false;
        }
        if (this.idTokenEncryptionEncValuesSupported != null ? !this.idTokenEncryptionEncValuesSupported.equals(that.idTokenEncryptionEncValuesSupported) : that.idTokenEncryptionEncValuesSupported != null) {
            return false;
        }
        if (this.displayValuesSupported != null ? !this.displayValuesSupported.equals(that.displayValuesSupported) : that.displayValuesSupported != null) {
            return false;
        }
        if (this.claimTypesSupported != null ? !this.claimTypesSupported.equals(that.claimTypesSupported) : that.claimTypesSupported != null) {
            return false;
        }
        if (this.claimsParameterSupported != null ? !this.claimsParameterSupported.equals(that.claimsParameterSupported) : that.claimsParameterSupported != null) {
            return false;
        }
        if (this.opTosUri != null ? !this.opTosUri.equals(that.opTosUri) : that.opTosUri != null) {
            return false;
        }
        if (this.opPolicyUri != null ? !this.opPolicyUri.equals(that.opPolicyUri) : that.opPolicyUri != null) {
            return false;
        }
        if (this.uriLocalesSupported != null ? !this.uriLocalesSupported.equals(that.uriLocalesSupported) : that.uriLocalesSupported != null) {
            return false;
        }
        if (this.claimsLocalesSupported != null ? !this.claimsLocalesSupported.equals(that.claimsLocalesSupported) : that.claimsLocalesSupported != null) {
            return false;
        }
        if (this.userinfoEncryptionAlgValuesSupported != null ? !this.userinfoEncryptionAlgValuesSupported.equals(that.userinfoEncryptionAlgValuesSupported) : that.userinfoEncryptionAlgValuesSupported != null) {
            return false;
        }
        if (this.userinfoEncryptionEncValuesSupported != null ? !this.userinfoEncryptionEncValuesSupported.equals(that.userinfoEncryptionEncValuesSupported) : that.userinfoEncryptionEncValuesSupported != null) {
            return false;
        }
        if (this.tokenEndpointAuthSigningAlgValuesSupported != null ? !this.tokenEndpointAuthSigningAlgValuesSupported.equals(that.tokenEndpointAuthSigningAlgValuesSupported) : that.tokenEndpointAuthSigningAlgValuesSupported != null) {
            return false;
        }
        if (this.requestObjectEncryptionAlgValuesSupported != null ? !this.requestObjectEncryptionAlgValuesSupported.equals(that.requestObjectEncryptionAlgValuesSupported) : that.requestObjectEncryptionAlgValuesSupported != null) {
            return false;
        }
        if (this.requestObjectEncryptionEncValuesSupported != null ? !this.requestObjectEncryptionEncValuesSupported.equals(that.requestObjectEncryptionEncValuesSupported) : that.requestObjectEncryptionEncValuesSupported != null) {
            return false;
        }
        return this.checkSessionIframe != null ? this.checkSessionIframe.equals(that.checkSessionIframe) : that.checkSessionIframe == null;
    }

    public int hashCode() {
        int result = this.authorizationEndpoint != null ? this.authorizationEndpoint.hashCode() : 0;
        result = 31 * result + (this.idTokenSigningAlgValuesSupported != null ? this.idTokenSigningAlgValuesSupported.hashCode() : 0);
        result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
        result = 31 * result + (this.jwksUri != null ? this.jwksUri.hashCode() : 0);
        result = 31 * result + (this.acrValuesSupported != null ? this.acrValuesSupported.hashCode() : 0);
        result = 31 * result + (this.responseTypesSupported != null ? this.responseTypesSupported.hashCode() : 0);
        result = 31 * result + (this.responseModesSupported != null ? this.responseModesSupported.hashCode() : 0);
        result = 31 * result + (this.scopesSupported != null ? this.scopesSupported.hashCode() : 0);
        result = 31 * result + (this.grantTypesSupported != null ? this.grantTypesSupported.hashCode() : 0);
        result = 31 * result + (this.subjectTypesSupported != null ? this.subjectTypesSupported.hashCode() : 0);
        result = 31 * result + (this.tokenEndpoint != null ? this.tokenEndpoint.hashCode() : 0);
        result = 31 * result + (this.tokenEndpointAuthMethodsSupported != null ? this.tokenEndpointAuthMethodsSupported.hashCode() : 0);
        result = 31 * result + (this.userinfoEndpoint != null ? this.userinfoEndpoint.hashCode() : 0);
        result = 31 * result + (this.registrationEndpoint != null ? this.registrationEndpoint.hashCode() : 0);
        result = 31 * result + (this.claimsSupported != null ? this.claimsSupported.hashCode() : 0);
        result = 31 * result + (this.codeChallengeMethodsSupported != null ? this.codeChallengeMethodsSupported.hashCode() : 0);
        result = 31 * result + (this.introspectionEndpoint != null ? this.introspectionEndpoint.hashCode() : 0);
        result = 31 * result + (this.introspectionEndpointAuthMethodsSupported != null ? this.introspectionEndpointAuthMethodsSupported.hashCode() : 0);
        result = 31 * result + (this.revocationEndpoint != null ? this.revocationEndpoint.hashCode() : 0);
        result = 31 * result + (this.revocationEndpointAuthMethodsSupported != null ? this.revocationEndpointAuthMethodsSupported.hashCode() : 0);
        result = 31 * result + (this.endSessionEndpoint != null ? this.endSessionEndpoint.hashCode() : 0);
        result = 31 * result + (this.requestParameterSupported != null ? this.requestParameterSupported.hashCode() : 0);
        result = 31 * result + (this.requestUriParameterSupported != null ? this.requestUriParameterSupported.hashCode() : 0);
        result = 31 * result + (this.requireRequestUriRegistration != null ? this.requireRequestUriRegistration.hashCode() : 0);
        result = 31 * result + (this.requestObjectSigningAlgValuesSupported != null ? this.requestObjectSigningAlgValuesSupported.hashCode() : 0);
        result = 31 * result + (this.serviceDocumentation != null ? this.serviceDocumentation.hashCode() : 0);
        result = 31 * result + (this.idTokenEncryptionEncValuesSupported != null ? this.idTokenEncryptionEncValuesSupported.hashCode() : 0);
        result = 31 * result + (this.displayValuesSupported != null ? this.displayValuesSupported.hashCode() : 0);
        result = 31 * result + (this.claimTypesSupported != null ? this.claimTypesSupported.hashCode() : 0);
        result = 31 * result + (this.claimsParameterSupported != null ? this.claimsParameterSupported.hashCode() : 0);
        result = 31 * result + (this.opTosUri != null ? this.opTosUri.hashCode() : 0);
        result = 31 * result + (this.opPolicyUri != null ? this.opPolicyUri.hashCode() : 0);
        result = 31 * result + (this.uriLocalesSupported != null ? this.uriLocalesSupported.hashCode() : 0);
        result = 31 * result + (this.claimsLocalesSupported != null ? this.claimsLocalesSupported.hashCode() : 0);
        result = 31 * result + (this.userinfoEncryptionAlgValuesSupported != null ? this.userinfoEncryptionAlgValuesSupported.hashCode() : 0);
        result = 31 * result + (this.userinfoEncryptionEncValuesSupported != null ? this.userinfoEncryptionEncValuesSupported.hashCode() : 0);
        result = 31 * result + (this.tokenEndpointAuthSigningAlgValuesSupported != null ? this.tokenEndpointAuthSigningAlgValuesSupported.hashCode() : 0);
        result = 31 * result + (this.requestObjectEncryptionAlgValuesSupported != null ? this.requestObjectEncryptionAlgValuesSupported.hashCode() : 0);
        result = 31 * result + (this.requestObjectEncryptionEncValuesSupported != null ? this.requestObjectEncryptionEncValuesSupported.hashCode() : 0);
        result = 31 * result + (this.checkSessionIframe != null ? this.checkSessionIframe.hashCode() : 0);
        return result;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String authorizationEndpoint;
        @NonNull
        private List<String> idTokenSigningAlgValuesSupported;
        @NonNull
        private String issuer;
        @NonNull
        private String jwksUri;
        @Nullable
        private List<String> acrValuesSupported;
        @Nullable
        private List<String> responseTypesSupported;
        @Nullable
        private List<String> responseModesSupported;
        @Nullable
        private List<String> scopesSupported;
        @Nullable
        private List<String> grantTypesSupported;
        @NonNull
        private List<String> subjectTypesSupported;
        @NonNull
        private String tokenEndpoint;
        @Nullable
        private List<String> tokenEndpointAuthMethodsSupported;
        @Nullable
        private String userinfoEndpoint;
        @Nullable
        private String registrationEndpoint;
        @Nullable
        private List<String> claimsSupported;
        @Nullable
        private List<String> codeChallengeMethodsSupported;
        @Nullable
        private String introspectionEndpoint;
        @Nullable
        private List<String> introspectionEndpointAuthMethodsSupported;
        @Nullable
        private String revocationEndpoint;
        @Nullable
        private List<String> revocationEndpointAuthMethodsSupported;
        @Nullable
        private String endSessionEndpoint;
        @Nullable
        private Boolean requestParameterSupported;
        @Nullable
        private Boolean requestUriParameterSupported;
        @Nullable
        private Boolean requireRequestUriRegistration;
        @Nullable
        private List<String> requestObjectSigningAlgValuesSupported;
        @Nullable
        private String serviceDocumentation;
        @Nullable
        private List<String> idTokenEncryptionEncValuesSupported;
        @Nullable
        private List<String> displayValuesSupported;
        @Nullable
        private List<String> claimTypesSupported;
        @NonNull
        private Boolean claimsParameterSupported = Boolean.FALSE;
        @Nullable
        private String opTosUri;
        @Nullable
        private String opPolicyUri;
        @Nullable
        private List<String> uriLocalesSupported;
        @Nullable
        private List<String> claimsLocalesSupported;
        @Nullable
        private List<String> userinfoEncryptionAlgValuesSupported;
        @Nullable
        private List<String> userinfoEncryptionEncValuesSupported;
        @Nullable
        private List<String> tokenEndpointAuthSigningAlgValuesSupported;
        @Nullable
        private List<String> requestObjectEncryptionAlgValuesSupported;
        @Nullable
        private List<String> requestObjectEncryptionEncValuesSupported;
        @Nullable
        private String checkSessionIframe;

        @NonNull
        public Builder authorizationEndpoint(@Nullable String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        @NonNull
        public Builder idTokenSigningAlgValuesSupported(@NonNull List<String> idTokenSigningAlgValuesSupported) {
            this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder issuer(@NonNull String issuer) {
            this.issuer = issuer;
            return this;
        }

        @NonNull
        public Builder jwksUri(@NonNull String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        @NonNull
        public Builder acrValuesSupported(@NonNull List<String> acrValuesSupported) {
            this.acrValuesSupported = acrValuesSupported;
            return this;
        }

        @NonNull
        public Builder responseTypesSupported(@Nullable List<String> responseTypesSupported) {
            this.responseTypesSupported = responseTypesSupported;
            return this;
        }

        @NonNull
        public Builder responseModesSupported(@Nullable List<String> responseModesSupported) {
            this.responseModesSupported = responseModesSupported;
            return this;
        }

        @NonNull
        public Builder scopesSupported(@Nullable List<String> scopesSupported) {
            this.scopesSupported = scopesSupported;
            return this;
        }

        @NonNull
        public Builder grantTypesSupported(@Nullable List<String> grantTypesSupported) {
            this.grantTypesSupported = grantTypesSupported;
            return this;
        }

        @NonNull
        public Builder subjectTypesSupported(@NonNull List<String> subjectTypesSupported) {
            this.subjectTypesSupported = subjectTypesSupported;
            return this;
        }

        @NonNull
        public Builder tokenEndpoint(@NonNull String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        @NonNull
        public Builder tokenEndpointAuthMethodsSupported(@Nullable List<String> tokenEndpointAuthMethodsSupported) {
            this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
            return this;
        }

        @NonNull
        public Builder userinfoEndpoint(@Nullable String userinfoEndpoint) {
            this.userinfoEndpoint = userinfoEndpoint;
            return this;
        }

        @NonNull
        public Builder registrationEndpoint(@Nullable String registrationEndpoint) {
            this.registrationEndpoint = registrationEndpoint;
            return this;
        }

        @NonNull
        public Builder claimsSupported(@Nullable List<String> claimsSupported) {
            this.claimsSupported = claimsSupported;
            return this;
        }

        @NonNull
        public Builder codeChallengeMethodsSupported(@Nullable List<String> codeChallengeMethodsSupported) {
            this.codeChallengeMethodsSupported = codeChallengeMethodsSupported;
            return this;
        }

        @NonNull
        public Builder introspectionEndpoint(@Nullable String introspectionEndpoint) {
            this.introspectionEndpoint = introspectionEndpoint;
            return this;
        }

        @NonNull
        public Builder introspectionEndpointAuthMethodsSupported(@Nullable List<String> introspectionEndpointAuthMethodsSupported) {
            this.introspectionEndpointAuthMethodsSupported = introspectionEndpointAuthMethodsSupported;
            return this;
        }

        @NonNull
        public Builder revocationEndpoint(@Nullable String revocationEndpoint) {
            this.revocationEndpoint = revocationEndpoint;
            return this;
        }

        @NonNull
        public Builder revocationEndpointAuthMethodsSupported(@Nullable List<String> revocationEndpointAuthMethodsSupported) {
            this.revocationEndpointAuthMethodsSupported = revocationEndpointAuthMethodsSupported;
            return this;
        }

        @NonNull
        public Builder endSessionEndpoint(@Nullable String endSessionEndpoint) {
            this.endSessionEndpoint = endSessionEndpoint;
            return this;
        }

        @NonNull
        public Builder requestParameterSupported(@Nullable Boolean requestParameterSupported) {
            this.requestParameterSupported = requestParameterSupported;
            return this;
        }

        @NonNull
        public Builder requestUriParameterSupported(@Nullable Boolean requestUriParameterSupported) {
            this.requestUriParameterSupported = requestUriParameterSupported;
            return this;
        }

        @NonNull
        public Builder requireRequestUriRegistration(@Nullable Boolean requireRequestUriRegistration) {
            this.requireRequestUriRegistration = requireRequestUriRegistration;
            return this;
        }

        @NonNull
        public Builder requestObjectSigningAlgValuesSupported(@Nullable List<String> requestObjectSigningAlgValuesSupported) {
            this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder serviceDocumentation(@Nullable String serviceDocumentation) {
            this.serviceDocumentation = serviceDocumentation;
            return this;
        }

        @NonNull
        public Builder idTokenEncryptionEncValuesSupported(@Nullable List<String> idTokenEncryptionEncValuesSupported) {
            this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
            return this;
        }

        @NonNull
        public Builder displayValuesSupported(@Nullable List<String> displayValuesSupported) {
            this.displayValuesSupported = displayValuesSupported;
            return this;
        }

        @NonNull
        public Builder claimTypesSupported(@Nullable List<String> claimTypesSupported) {
            this.claimTypesSupported = claimTypesSupported;
            return this;
        }

        @NonNull
        public Builder claimsParameterSupported(@NonNull Boolean claimsParameterSupported) {
            this.claimsParameterSupported = claimsParameterSupported;
            return this;
        }

        @NonNull
        public Builder opTosUri(@Nullable String opTosUri) {
            this.opTosUri = opTosUri;
            return this;
        }

        @NonNull
        public Builder opPolicyUri(@Nullable String opPolicyUri) {
            this.opPolicyUri = opPolicyUri;
            return this;
        }

        @NonNull
        public Builder uriLocalesSupported(@Nullable List<String> uriLocalesSupported) {
            this.uriLocalesSupported = uriLocalesSupported;
            return this;
        }

        @NonNull
        public Builder claimsLocalesSupported(@Nullable List<String> claimsLocalesSupported) {
            this.claimsLocalesSupported = claimsLocalesSupported;
            return this;
        }

        @NonNull
        public Builder userinfoEncryptionAlgValuesSupported(@Nullable List<String> userinfoEncryptionAlgValuesSupported) {
            this.userinfoEncryptionAlgValuesSupported = userinfoEncryptionAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder userinfoEncryptionEncValuesSupported(@Nullable List<String> userinfoEncryptionEncValuesSupported) {
            this.userinfoEncryptionEncValuesSupported = userinfoEncryptionEncValuesSupported;
            return this;
        }

        @NonNull
        public Builder tokenEndpointAuthSigningAlgValuesSupported(@Nullable List<String> tokenEndpointAuthSigningAlgValuesSupported) {
            this.tokenEndpointAuthSigningAlgValuesSupported = tokenEndpointAuthSigningAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder requestObjectEncryptionAlgValuesSupported(@Nullable List<String> requestObjectEncryptionAlgValuesSupported) {
            this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
            return this;
        }

        @NonNull
        public Builder requestObjectEncryptionEncValuesSupported(@Nullable List<String> requestObjectEncryptionEncValuesSupported) {
            this.requestObjectEncryptionEncValuesSupported = requestObjectEncryptionEncValuesSupported;
            return this;
        }

        @NonNull
        public Builder checkSessionIframe(@Nullable String checkSessionIframe) {
            this.checkSessionIframe = checkSessionIframe;
            return this;
        }

        @NonNull
        public DefaultOpenIdProviderMetadata build() {
            DefaultOpenIdProviderMetadata metadata = new DefaultOpenIdProviderMetadata();
            metadata.setAuthorizationEndpoint(Objects.requireNonNull(this.authorizationEndpoint));
            metadata.setIdTokenSigningAlgValuesSupported(this.idTokenSigningAlgValuesSupported);
            metadata.setIssuer(this.issuer);
            metadata.setJwksUri(this.jwksUri);
            metadata.setAcrValuesSupported(this.acrValuesSupported);
            metadata.setResponseTypesSupported(this.responseTypesSupported);
            metadata.setResponseModesSupported(this.responseModesSupported);
            metadata.setScopesSupported(this.scopesSupported);
            metadata.setGrantTypesSupported(this.grantTypesSupported);
            metadata.setSubjectTypesSupported(this.subjectTypesSupported);
            metadata.setTokenEndpoint(this.tokenEndpoint);
            metadata.setTokenEndpointAuthMethodsSupported(this.tokenEndpointAuthMethodsSupported);
            metadata.setUserinfoEndpoint(this.userinfoEndpoint);
            metadata.setRegistrationEndpoint(this.registrationEndpoint);
            metadata.setClaimsSupported(this.claimsSupported);
            metadata.setCodeChallengeMethodsSupported(this.codeChallengeMethodsSupported);
            metadata.setIntrospectionEndpoint(this.introspectionEndpoint);
            metadata.setIntrospectionEndpointAuthMethodsSupported(this.introspectionEndpointAuthMethodsSupported);
            metadata.setRevocationEndpoint(this.revocationEndpoint);
            metadata.setRevocationEndpointAuthMethodsSupported(this.revocationEndpointAuthMethodsSupported);
            metadata.setEndSessionEndpoint(this.endSessionEndpoint);
            metadata.setRequestParameterSupported(this.requestParameterSupported);
            metadata.setRequestUriParameterSupported(this.requestUriParameterSupported);
            metadata.setRequireRequestUriRegistration(this.requireRequestUriRegistration);
            metadata.setRequestObjectSigningAlgValuesSupported(this.requestObjectSigningAlgValuesSupported);
            metadata.setServiceDocumentation(this.serviceDocumentation);
            metadata.setIdTokenEncryptionEncValuesSupported(this.idTokenEncryptionEncValuesSupported);
            metadata.setDisplayValuesSupported(this.displayValuesSupported);
            metadata.setClaimTypesSupported(this.claimTypesSupported);
            metadata.setClaimsParameterSupported(this.claimsParameterSupported);
            metadata.setOpTosUri(this.opTosUri);
            metadata.setOpPolicyUri(this.opPolicyUri);
            metadata.setUriLocalesSupported(this.uriLocalesSupported);
            metadata.setClaimsLocalesSupported(this.claimsLocalesSupported);
            metadata.setUserinfoEncryptionAlgValuesSupported(this.userinfoEncryptionAlgValuesSupported);
            metadata.setUserinfoEncryptionEncValuesSupported(this.userinfoEncryptionEncValuesSupported);
            metadata.setTokenEndpointAuthSigningAlgValuesSupported(this.tokenEndpointAuthSigningAlgValuesSupported);
            metadata.setRequestObjectEncryptionAlgValuesSupported(this.requestObjectEncryptionAlgValuesSupported);
            metadata.setRequestObjectEncryptionEncValuesSupported(this.requestObjectEncryptionEncValuesSupported);
            metadata.setCheckSessionIframe(this.checkSessionIframe);
            return metadata;
        }
    }
}

