/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.password;

import com.nimbusds.jwt.JWT;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.endpoint.AuthenticationMethod;
import io.micronaut.security.oauth2.endpoint.DefaultSecureEndpoint;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.context.OpenIdPasswordTokenRequestContext;
import io.micronaut.security.oauth2.endpoint.token.response.JWTOpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdTokenResponse;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdTokenResponseValidator;
import java.text.ParseException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class OpenIdPasswordAuthenticationProvider
implements AuthenticationProvider {
    private final TokenEndpointClient tokenEndpointClient;
    private final SecureEndpoint secureEndpoint;
    private final OauthClientConfiguration clientConfiguration;
    private final OpenIdProviderMetadata openIdProviderMetadata;
    private final OpenIdAuthenticationMapper openIdAuthenticationMapper;
    private final OpenIdTokenResponseValidator tokenResponseValidator;

    public OpenIdPasswordAuthenticationProvider(OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, TokenEndpointClient tokenEndpointClient, OpenIdAuthenticationMapper openIdAuthenticationMapper, OpenIdTokenResponseValidator tokenResponseValidator) {
        this.tokenEndpointClient = tokenEndpointClient;
        this.clientConfiguration = clientConfiguration;
        this.openIdProviderMetadata = openIdProviderMetadata;
        this.openIdAuthenticationMapper = openIdAuthenticationMapper;
        this.tokenResponseValidator = tokenResponseValidator;
        Optional tokenEndpointConfiguration = clientConfiguration.getOpenid().flatMap(OpenIdClientConfiguration::getToken);
        if (!tokenEndpointConfiguration.isPresent()) {
            throw new IllegalArgumentException("Missing token endpoint configuration");
        }
        this.secureEndpoint = this.getTokenEndpoint(openIdProviderMetadata);
    }

    public Publisher<AuthenticationResponse> authenticate(HttpRequest<?> httpRequest, AuthenticationRequest<?, ?> authenticationRequest) {
        OpenIdPasswordTokenRequestContext requestContext = new OpenIdPasswordTokenRequestContext(authenticationRequest, this.secureEndpoint, this.clientConfiguration);
        return Flux.from(this.tokenEndpointClient.sendRequest(requestContext)).switchMap(response -> Flux.create(emitter -> {
            Optional<JWT> jwt = this.tokenResponseValidator.validate(this.clientConfiguration, this.openIdProviderMetadata, (OpenIdTokenResponse)response, null);
            if (jwt.isPresent()) {
                try {
                    JWTOpenIdClaims claims = new JWTOpenIdClaims(jwt.get().getJWTClaimsSet());
                    emitter.next((Object)this.openIdAuthenticationMapper.createAuthenticationResponse(this.clientConfiguration.getName(), (OpenIdTokenResponse)response, claims, null));
                    emitter.complete();
                }
                catch (ParseException e) {
                    emitter.error((Throwable)e);
                }
            } else {
                emitter.error((Throwable)AuthenticationResponse.exception((String)"JWT validation failed"));
            }
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.ERROR));
    }

    protected SecureEndpoint getTokenEndpoint(OpenIdProviderMetadata openIdProviderMetadata) {
        List<String> authMethodsSupported = openIdProviderMetadata.getTokenEndpointAuthMethodsSupported();
        List authenticationMethods = null;
        if (authMethodsSupported != null) {
            authenticationMethods = authMethodsSupported.stream().map(String::toUpperCase).map(AuthenticationMethod::valueOf).collect(Collectors.toList());
        }
        return new DefaultSecureEndpoint(openIdProviderMetadata.getTokenEndpoint(), authenticationMethods);
    }
}

