/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.Named;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsConfiguration;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import java.util.Optional;

@Internal
public class ClientCredentialsEnabled
implements Condition {
    public boolean matches(ConditionContext context) {
        Optional optional;
        AnnotationMetadataProvider component = context.getComponent();
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext && component instanceof ValueResolver && (optional = ((ValueResolver)component).get((CharSequence)Named.class.getName(), String.class)).isPresent()) {
            String name = (String)optional.get();
            OauthClientConfiguration clientConfiguration = (OauthClientConfiguration)beanContext.getBean(OauthClientConfiguration.class, Qualifiers.byName((String)name));
            if (clientConfiguration.isEnabled()) {
                Optional<ClientCredentialsConfiguration> clientCredentialsConfiguration = clientConfiguration.getClientCredentials();
                if (!clientCredentialsConfiguration.isPresent() || clientCredentialsConfiguration.get().isEnabled()) {
                    return true;
                }
                context.fail("Client credentials is disabled for the client [" + name + "]");
                return false;
            }
            context.fail("Client credentials is disabled for the client [" + name + "]");
            return false;
        }
        return true;
    }
}

