/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import java.util.Arrays;
import java.util.List;

@ReflectiveAccess
@Introspected
@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class DefaultOpenIdProviderMetadata
implements OpenIdProviderMetadata {
    private String authorizationEndpoint;
    private List<String> idTokenSigningAlgValuesSupported;
    private String issuer;
    private String jwksUri;
    private List<String> acrValuesSupported;
    private List<String> responseTypesSupported;
    private List<String> responseModesSupported;
    private List<String> scopesSupported;
    private List<String> grantTypesSupported;
    private List<String> subjectTypesSupported;
    private String tokenEndpoint;
    private List<String> tokenEndpointAuthMethodsSupported;
    private String userinfoEndpoint;
    private String registrationEndpoint;
    private List<String> claimsSupported;
    private List<String> codeChallengeMethodsSupported;
    private String introspectionEndpoint;
    private List<String> introspectionEndpointAuthMethodsSupported;
    private String revocationEndpoint;
    private List<String> revocationEndpointAuthMethodsSupported;
    private String endSessionEndpoint;
    private Boolean requestParameterSupported;
    private Boolean requestUriParameterSupported;
    private Boolean requireRequestUriRegistration;
    private List<String> requestObjectSigningAlgValuesSupported;
    private String serviceDocumentation;
    private List<String> idTokenEncryptionEncValuesSupported;
    private List<String> displayValuesSupported;
    private List<String> claimTypesSupported;
    private Boolean claimsParameterSupported = Boolean.FALSE;
    private String opTosUri;
    private String opPolicyUri;
    private List<String> uriLocalesSupported;
    private List<String> claimsLocalesSupported;
    private List<String> userinfoEncryptionAlgValuesSupported;
    private List<String> userinfoEncryptionEncValuesSupported;
    private List<String> tokenEndpointAuthSigningAlgValuesSupported;
    private List<String> requestObjectEncryptionAlgValuesSupported;
    private List<String> requestObjectEncryptionEncValuesSupported;
    private String checkSessionIframe;

    @Override
    @Nullable
    public Boolean getRequireRequestUriRegistration() {
        return this.requireRequestUriRegistration;
    }

    @Nullable
    public Boolean getDefaultRequireRequestUriRegistration() {
        return Boolean.FALSE;
    }

    public void setRequireRequestUriRegistration(@Nullable Boolean requireRequestUriRegistration) {
        this.requireRequestUriRegistration = requireRequestUriRegistration;
    }

    @Override
    @NonNull
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(@NonNull String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public void setUserinfoEncryptionEncValuesSupported(@Nullable List<String> userinfoEncryptionEncValuesSupported) {
        this.userinfoEncryptionEncValuesSupported = userinfoEncryptionEncValuesSupported;
    }

    @Override
    @NonNull
    public List<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getIdTokenEncryptionEncValuesSupported() {
        return this.idTokenEncryptionEncValuesSupported;
    }

    public void setIdTokenEncryptionEncValuesSupported(@Nullable List<String> idTokenEncryptionEncValuesSupported) {
        this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getUserInfoEncryptionAlgValuesSupported() {
        return this.userinfoEncryptionAlgValuesSupported;
    }

    public void setUserinfoEncryptionAlgValuesSupported(@Nullable List<String> userinfoEncryptionAlgValuesSupported) {
        this.userinfoEncryptionAlgValuesSupported = userinfoEncryptionAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getUserinfoEncryptionEncValuesSupported() {
        return this.userinfoEncryptionEncValuesSupported;
    }

    public void setIdTokenSigningAlgValuesSupported(@NonNull List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }

    @Override
    @NonNull
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(@NonNull String issuer) {
        this.issuer = issuer;
    }

    @Override
    @NonNull
    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(@NonNull String jwksUri) {
        this.jwksUri = jwksUri;
    }

    @Override
    @Nullable
    public List<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    @NonNull
    public List<String> getDefaultResponseTypesSupported() {
        return Arrays.asList("query", "fragment");
    }

    public void setResponseTypesSupported(@Nullable List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    @Override
    @Nullable
    public List<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public void setScopesSupported(@Nullable List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    @Override
    @NonNull
    public List<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public void setSubjectTypesSupported(@NonNull List<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    @Override
    @NonNull
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(@Nullable String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    @Override
    @Nullable
    public List<String> getTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    @Override
    @Nullable
    public List<String> getTokenEndpointAuthSigningAlgValuesSupported() {
        return this.tokenEndpointAuthSigningAlgValuesSupported;
    }

    public void setTokenEndpointAuthSigningAlgValuesSupported(@Nullable List<String> tokenEndpointAuthSigningAlgValuesSupported) {
        this.tokenEndpointAuthSigningAlgValuesSupported = tokenEndpointAuthSigningAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getDisplayValuesSupported() {
        return this.displayValuesSupported;
    }

    public void setDisplayValuesSupported(@Nullable List<String> displayValuesSupported) {
        this.displayValuesSupported = displayValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getClaimTypesSupported() {
        return this.claimTypesSupported;
    }

    public void setClaimTypesSupported(@Nullable List<String> claimTypesSupported) {
        this.claimTypesSupported = claimTypesSupported;
    }

    public void setTokenEndpointAuthMethodsSupported(@Nullable List<String> tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
    }

    @Override
    @Nullable
    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public void setUserinfoEndpoint(@Nullable String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

    @Override
    @Nullable
    public List<String> getResponseModesSupported() {
        return this.responseModesSupported;
    }

    public void setResponseModesSupported(@Nullable List<String> responseModesSupported) {
        this.responseModesSupported = responseModesSupported;
    }

    @Override
    @Nullable
    public List<String> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    @NonNull
    public List<String> getDefaultGrantTypesSupported() {
        return Arrays.asList("authorization_code", "implicit");
    }

    @Override
    @Nullable
    public List<String> getAcrValuesSupported() {
        return this.acrValuesSupported;
    }

    public void setAcrValuesSupported(@Nullable List<String> acrValuesSupported) {
        this.acrValuesSupported = acrValuesSupported;
    }

    public void setGrantTypesSupported(@Nullable List<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    @Override
    @Nullable
    public String getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    public void setRegistrationEndpoint(@Nullable String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
    }

    @Override
    @Nullable
    public List<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    @Override
    @Nullable
    public String getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    public void setServiceDocumentation(@Nullable String serviceDocumentation) {
        this.serviceDocumentation = serviceDocumentation;
    }

    @Override
    @Nullable
    public List<String> getClaimsLocalesSupported() {
        return this.claimsLocalesSupported;
    }

    public void setClaimsLocalesSupported(@Nullable List<String> claimsLocalesSupported) {
        this.claimsLocalesSupported = claimsLocalesSupported;
    }

    @Override
    @Nullable
    public List<String> getUriLocalesSupported() {
        return this.uriLocalesSupported;
    }

    public void setUriLocalesSupported(@Nullable List<String> uriLocalesSupported) {
        this.uriLocalesSupported = uriLocalesSupported;
    }

    @Override
    @Nullable
    public Boolean getClaimsParameterSupported() {
        return this.claimsParameterSupported;
    }

    public void setClaimsParameterSupported(@Nullable Boolean claimsParameterSupported) {
        this.claimsParameterSupported = claimsParameterSupported;
    }

    public void setClaimsSupported(@Nullable List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    @Override
    @Nullable
    public List<String> getCodeChallengeMethodsSupported() {
        return this.codeChallengeMethodsSupported;
    }

    public void setCodeChallengeMethodsSupported(@Nullable List<String> codeChallengeMethodsSupported) {
        this.codeChallengeMethodsSupported = codeChallengeMethodsSupported;
    }

    @Override
    @Nullable
    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpoint(@Nullable String introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }

    @Override
    @Nullable
    public List<String> getIntrospectionEndpointAuthMethodsSupported() {
        return this.introspectionEndpointAuthMethodsSupported;
    }

    public void setIntrospectionEndpointAuthMethodsSupported(@Nullable List<String> introspectionEndpointAuthMethodsSupported) {
        this.introspectionEndpointAuthMethodsSupported = introspectionEndpointAuthMethodsSupported;
    }

    @Override
    @Nullable
    public String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    public void setRevocationEndpoint(@Nullable String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    @Override
    @Nullable
    public List<String> getRevocationEndpointAuthMethodsSupported() {
        return this.revocationEndpointAuthMethodsSupported;
    }

    public void setRevocationEndpointAuthMethodsSupported(@Nullable List<String> revocationEndpointAuthMethodsSupported) {
        this.revocationEndpointAuthMethodsSupported = revocationEndpointAuthMethodsSupported;
    }

    public void setCheckSessionIframe(@Nullable String checkSessionIframe) {
        this.checkSessionIframe = checkSessionIframe;
    }

    @Override
    @Nullable
    public String getCheckSessionIframe() {
        return this.checkSessionIframe;
    }

    @Override
    @Nullable
    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpoint(@Nullable String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    @Override
    @Nullable
    public Boolean getRequestParameterSupported() {
        return this.requestParameterSupported;
    }

    @NonNull
    public Boolean getDefaultRequestParameterSupported() {
        return Boolean.FALSE;
    }

    @Override
    @Nullable
    public Boolean getRequestUriParameterSupported() {
        return this.requestUriParameterSupported;
    }

    @NonNull
    public Boolean getDefaultRequestUriParameterSupported() {
        return Boolean.TRUE;
    }

    public void setRequestUriParameterSupported(@Nullable Boolean requestUriParameterSupported) {
        this.requestUriParameterSupported = requestUriParameterSupported;
    }

    @Override
    @Nullable
    public String getOpPolicyUri() {
        return this.opPolicyUri;
    }

    public void setOpPolicyUri(@Nullable String opPolicyUri) {
        this.opPolicyUri = opPolicyUri;
    }

    @Override
    @Nullable
    public String getOpTosUri() {
        return this.opTosUri;
    }

    public void setOpTosUri(@Nullable String opTosUri) {
        this.opTosUri = opTosUri;
    }

    public void setRequestParameterSupported(@Nullable Boolean requestParameterSupported) {
        this.requestParameterSupported = requestParameterSupported;
    }

    @Override
    @Nullable
    public List<String> getRequestObjectSigningAlgValuesSupported() {
        return this.requestObjectSigningAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getRequestObjectEncryptionAlgValuesSupported() {
        return this.requestObjectEncryptionAlgValuesSupported;
    }

    public void setRequestObjectEncryptionAlgValuesSupported(@Nullable List<String> requestObjectEncryptionAlgValuesSupported) {
        this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
    }

    @Override
    @Nullable
    public List<String> getRequestObjectEncryptionEncValuesSupported() {
        return this.requestObjectEncryptionEncValuesSupported;
    }

    public void setRequestObjectEncryptionEncValuesSupported(@Nullable List<String> requestObjectEncryptionEncValuesSupported) {
        this.requestObjectEncryptionEncValuesSupported = requestObjectEncryptionEncValuesSupported;
    }

    public void setRequestObjectSigningAlgValuesSupported(@Nullable List<String> requestObjectSigningAlgValuesSupported) {
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
    }
}

