/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.grants;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.oauth2.grants.AsMap;
import io.micronaut.security.oauth2.grants.GrantType;
import io.micronaut.security.oauth2.grants.SecureGrant;
import io.micronaut.security.oauth2.grants.SecureGrantMap;
import java.util.Map;

@Introspected
@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class AuthorizationCodeGrant
implements SecureGrant,
AsMap {
    private static final String KEY_GRANT_TYPE = "grant_type";
    private static final String KEY_CLIENT_ID = "client_id";
    private static final String KEY_CLIENT_SECRET = "client_secret";
    private static final String KEY_REDIRECT_URI = "redirect_uri";
    private static final String KEY_CODE = "code";
    private String grantType = GrantType.AUTHORIZATION_CODE.toString();
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private String code;

    @NonNull
    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(@NonNull String grantType) {
        this.grantType = grantType;
    }

    @NonNull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(@NonNull String clientId) {
        this.clientId = clientId;
    }

    @Override
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @NonNull
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(@NonNull String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @NonNull
    public String getCode() {
        return this.code;
    }

    public void setCode(@NonNull String code) {
        this.code = code;
    }

    @Override
    public Map<String, String> toMap() {
        SecureGrantMap m = new SecureGrantMap(5);
        m.put(KEY_GRANT_TYPE, this.getGrantType());
        m.put(KEY_CODE, this.getCode());
        if (this.clientId != null) {
            m.put(KEY_CLIENT_ID, this.clientId);
        }
        if (this.clientSecret != null) {
            m.put(KEY_CLIENT_SECRET, this.clientSecret);
        }
        if (this.redirectUri != null) {
            m.put(KEY_REDIRECT_URI, this.getRedirectUri());
        }
        return m;
    }
}

