/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.request;

import io.micronaut.context.BeanContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.endpoint.endsession.request.Auth0EndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.AwsCognitoEndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.EndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.request.OktaEndSessionEndpoint;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import io.micronaut.security.token.reader.TokenResolver;
import jakarta.inject.Singleton;
import java.net.URL;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EndSessionEndpointResolver {
    private static final Logger LOG = LoggerFactory.getLogger(EndSessionEndpointResolver.class);
    private static final String OKTA = "okta";
    private static final String COGNITO = "cognito";
    private static final String AUTH0 = "auth0";
    private final BeanContext beanContext;

    public EndSessionEndpointResolver(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public Optional<EndSessionEndpoint> resolve(OauthClientConfiguration oauthClientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder) {
        return this.resolve(oauthClientConfiguration, () -> openIdProviderMetadata, endSessionCallbackUrlBuilder);
    }

    public Optional<EndSessionEndpoint> resolve(OauthClientConfiguration oauthClientConfiguration, Supplier<OpenIdProviderMetadata> openIdProviderMetadata, EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder) {
        String issuer;
        EndSessionEndpoint endSessionEndpoint;
        String providerName = oauthClientConfiguration.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving the end session endpoint for provider [{}]. Looking for a bean with the provider name qualifier", (Object)providerName);
        }
        if ((endSessionEndpoint = (EndSessionEndpoint)this.beanContext.findBean(EndSessionEndpoint.class, Qualifiers.byName((String)providerName)).orElse(null)) != null) {
            return Optional.of(endSessionEndpoint);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No EndSessionEndpoint bean found with a name qualifier of [{}]", (Object)providerName);
        }
        if ((issuer = (String)oauthClientConfiguration.getOpenid().flatMap(OpenIdClientConfiguration::getIssuer).map(URL::toString).orElse(null)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No EndSessionEndpoint can be resolved. Issuer is null for provider [{}]", (Object)providerName);
            }
            return Optional.empty();
        }
        if (issuer.contains(OKTA)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolved the OktaEndSessionEndpoint for provider [{}]", (Object)providerName);
            }
            SecurityConfiguration securityConfiguration = (SecurityConfiguration)this.beanContext.getBean(SecurityConfiguration.class);
            TokenResolver tokenResolver = (TokenResolver)this.beanContext.getBean(TokenResolver.class);
            return Optional.of(new OktaEndSessionEndpoint(endSessionCallbackUrlBuilder, oauthClientConfiguration, openIdProviderMetadata, securityConfiguration, tokenResolver));
        }
        if (issuer.contains(COGNITO)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolved the AwsCognitoEndSessionEndpoint for provider [{}]", (Object)providerName);
            }
            return Optional.of(new AwsCognitoEndSessionEndpoint(endSessionCallbackUrlBuilder, oauthClientConfiguration, openIdProviderMetadata));
        }
        if (issuer.contains(AUTH0)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolved the Auth0EndSessionEndpoint for provider [{}]", (Object)providerName);
            }
            return Optional.of(new Auth0EndSessionEndpoint(endSessionCallbackUrlBuilder, oauthClientConfiguration, openIdProviderMetadata));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No EndSessionEndpoint can be resolved. The issuer for provider [{}] does not match any of the providers supported by default", (Object)providerName);
        }
        return Optional.empty();
    }
}

