/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.grants;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.security.oauth2.grants.AsMap;
import io.micronaut.security.oauth2.grants.GrantType;
import io.micronaut.security.oauth2.grants.SecureGrant;
import io.micronaut.security.oauth2.grants.SecureGrantMap;
import java.util.Map;
import javax.validation.constraints.NotBlank;

@Introspected
@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ClientCredentialsGrant
implements SecureGrant,
AsMap {
    public static final String KEY_GRANT_TYPE = "grant_type";
    public static final String KEY_SCOPES = "scope";
    @NonNull
    @NotBlank
    private String grantType = GrantType.CLIENT_CREDENTIALS.toString();
    @Nullable
    private String scope;
    @Nullable
    private String clientId;
    @Nullable
    private String clientSecret;

    @NonNull
    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(@NonNull String grantType) {
        this.grantType = grantType;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    @NonNull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(@NonNull String clientId) {
        this.clientId = clientId;
    }

    @Override
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public Map<String, String> toMap() {
        SecureGrantMap m = new SecureGrantMap(2);
        m.put(KEY_GRANT_TYPE, this.getGrantType());
        if (StringUtils.isNotEmpty((CharSequence)this.scope)) {
            m.put(KEY_SCOPES, this.scope);
        }
        if (this.clientId != null) {
            m.put("client_id", this.clientId);
        }
        if (this.clientSecret != null) {
            m.put("client_secret", this.clientSecret);
        }
        return m;
    }
}

