/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.request;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.request.OauthAuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.request.ResponseType;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateFactory;
import io.micronaut.security.oauth2.url.OauthRouteUrlBuilder;
import java.util.List;
import java.util.Optional;

@Prototype
@Internal
class DefaultOauthAuthorizationRequest
implements OauthAuthorizationRequest {
    private final HttpRequest<?> request;
    private final OauthClientConfiguration oauthClientConfiguration;
    private final OauthRouteUrlBuilder oauthRouteUrlBuilder;
    private final StateFactory stateFactory;

    DefaultOauthAuthorizationRequest(@Parameter HttpRequest<?> request, @Parameter OauthClientConfiguration oauthClientConfiguration, OauthRouteUrlBuilder oauthRouteUrlBuilder, @Nullable StateFactory stateFactory) {
        this.request = request;
        this.oauthClientConfiguration = oauthClientConfiguration;
        this.oauthRouteUrlBuilder = oauthRouteUrlBuilder;
        this.stateFactory = stateFactory;
    }

    @Override
    @NonNull
    public String getClientId() {
        return this.oauthClientConfiguration.getClientId();
    }

    @Override
    public Optional<String> getState(MutableHttpResponse response) {
        return Optional.ofNullable(this.stateFactory).map(sf -> sf.buildState(this.request, response, this));
    }

    @Override
    @NonNull
    public List<String> getScopes() {
        return this.oauthClientConfiguration.getScopes();
    }

    @Override
    @NonNull
    public String getResponseType() {
        return ResponseType.CODE.toString();
    }

    @Override
    public Optional<String> getRedirectUri() {
        return Optional.of(this.oauthRouteUrlBuilder.buildCallbackUrl(this.request, this.oauthClientConfiguration.getName()).toString());
    }
}

